<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generateTokenRequest StructType
 * @subpackage Structs
 */
class GenerateTokenRequest extends AbstractStructBase
{
    /**
     * The contractNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contractNumber;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The outputFormat
     * @var \StructType\TypeOutputFormat
     */
    public $outputFormat;
    /**
     * The letter
     * @var \StructType\TypeLetter
     */
    public $letter;
    /**
     * The fields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TypeFields
     */
    public $fields;
    /**
     * Constructor method for generateTokenRequest
     * @uses GenerateTokenRequest::setContractNumber()
     * @uses GenerateTokenRequest::setPassword()
     * @uses GenerateTokenRequest::setOutputFormat()
     * @uses GenerateTokenRequest::setLetter()
     * @uses GenerateTokenRequest::setFields()
     * @param string $contractNumber
     * @param string $password
     * @param \StructType\TypeOutputFormat $outputFormat
     * @param \StructType\TypeLetter $letter
     * @param \StructType\TypeFields $fields
     */
    public function __construct($contractNumber = null, $password = null, \StructType\TypeOutputFormat $outputFormat = null, \StructType\TypeLetter $letter = null, \StructType\TypeFields $fields = null)
    {
        $this
            ->setContractNumber($contractNumber)
            ->setPassword($password)
            ->setOutputFormat($outputFormat)
            ->setLetter($letter)
            ->setFields($fields);
    }
    /**
     * Get contractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->contractNumber;
    }
    /**
     * Set contractNumber value
     * @param string $contractNumber
     * @return \StructType\GenerateTokenRequest
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractNumber, true), gettype($contractNumber)), __LINE__);
        }
        $this->contractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GenerateTokenRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get outputFormat value
     * @return \StructType\TypeOutputFormat|null
     */
    public function getOutputFormat()
    {
        return $this->outputFormat;
    }
    /**
     * Set outputFormat value
     * @param \StructType\TypeOutputFormat $outputFormat
     * @return \StructType\GenerateTokenRequest
     */
    public function setOutputFormat(\StructType\TypeOutputFormat $outputFormat = null)
    {
        $this->outputFormat = $outputFormat;
        return $this;
    }
    /**
     * Get letter value
     * @return \StructType\TypeLetter|null
     */
    public function getLetter()
    {
        return $this->letter;
    }
    /**
     * Set letter value
     * @param \StructType\TypeLetter $letter
     * @return \StructType\GenerateTokenRequest
     */
    public function setLetter(\StructType\TypeLetter $letter = null)
    {
        $this->letter = $letter;
        return $this;
    }
    /**
     * Get fields value
     * @return \StructType\TypeFields|null
     */
    public function getFields()
    {
        return $this->fields;
    }
    /**
     * Set fields value
     * @param \StructType\TypeFields $fields
     * @return \StructType\GenerateTokenRequest
     */
    public function setFields(\StructType\TypeFields $fields = null)
    {
        $this->fields = $fields;
        return $this;
    }
}
