<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getListMailBoxPickingDates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListMailBoxPickingDates $parameters
     * @return \StructType\GetListMailBoxPickingDatesResponse|bool
     */
    public function getListMailBoxPickingDates(\StructType\GetListMailBoxPickingDates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getListMailBoxPickingDates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLabel $parameters
     * @return \StructType\GetLabelResponse|bool
     */
    public function getLabel(\StructType\GetLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductInter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductInter $parameters
     * @return \StructType\GetProductInterResponse|bool
     */
    public function getProductInter(\StructType\GetProductInter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductInter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBordereauByNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBordereauByNumber $parameters
     * @return \StructType\GetBordereauByNumberResponse|bool
     */
    public function getBordereauByNumber(\StructType\GetBordereauByNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBordereauByNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBordereauByNumberResponse|\StructType\GetLabelResponse|\StructType\GetListMailBoxPickingDatesResponse|\StructType\GetProductInterResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
