<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL =>
 * 'http://www.agenciatributaria.es/static_files/AEAT/Contenidos_Comunes/La_Agencia_Tributaria/Modelos_y_formularios/Suministro_inmediato_informacion/FicherosSuministros/V_05/SuministroFactEmitidas.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.agenciatributaria.es/static_files/AEAT/Contenidos_Comunes/La_Agencia_Tributaria/Modelos_y_formularios/Suministro_inmediato_informacion/FicherosSuministros/V_05/SuministroFactEmitidas.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Suministro ServiceType
 */
$suministro = new \ServiceType\Suministro($options);
/**
 * Sample call for SuministroLRFacturasEmitidas operation/method
 */
if ($suministro->SuministroLRFacturasEmitidas(new \StructType\SuministroLRFacturasEmitidas()) !== false) {
    print_r($suministro->getResult());
} else {
    print_r($suministro->getLastError());
}
/**
 * Samples for Anulacion ServiceType
 */
$anulacion = new \ServiceType\Anulacion($options);
/**
 * Sample call for AnulacionLRFacturasEmitidas operation/method
 */
if ($anulacion->AnulacionLRFacturasEmitidas(new \StructType\BajaLRFacturasEmitidas()) !== false) {
    print_r($anulacion->getResult());
} else {
    print_r($anulacion->getLastError());
}
/**
 * Samples for Consulta ServiceType
 */
$consulta = new \ServiceType\Consulta($options);
/**
 * Sample call for ConsultaLRFacturasEmitidas operation/method
 */
if ($consulta->ConsultaLRFacturasEmitidas(new \StructType\LRConsultaEmitidasType()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
