<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaLRFEmitidasType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Respuesta a un envío Sii para suministro de Facturas emitidas
 * @subpackage Structs
 */
class RespuestaLRFEmitidasType extends RespuestaComunAltaType
{
    /**
     * The RespuestaLinea
     * Meta informations extracted from the WSDL
     * - documentation: Estado detallado de cada línea del suministro.
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var \StructType\RespuestaExpedidaType[]
     */
    public $RespuestaLinea;
    /**
     * Constructor method for RespuestaLRFEmitidasType
     * @uses RespuestaLRFEmitidasType::setRespuestaLinea()
     * @param \StructType\RespuestaExpedidaType[] $respuestaLinea
     */
    public function __construct(array $respuestaLinea = array())
    {
        $this
            ->setRespuestaLinea($respuestaLinea);
    }
    /**
     * Get RespuestaLinea value
     * @return \StructType\RespuestaExpedidaType[]|null
     */
    public function getRespuestaLinea()
    {
        return $this->RespuestaLinea;
    }
    /**
     * Set RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaExpedidaType[] $respuestaLinea
     * @return \StructType\RespuestaLRFEmitidasType
     */
    public function setRespuestaLinea(array $respuestaLinea = array())
    {
        foreach ($respuestaLinea as $respuestaLRFEmitidasTypeRespuestaLineaItem) {
            // validation for constraint: itemType
            if (!$respuestaLRFEmitidasTypeRespuestaLineaItem instanceof \StructType\RespuestaExpedidaType) {
                throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaExpedidaType, "%s" given', is_object($respuestaLRFEmitidasTypeRespuestaLineaItem) ? get_class($respuestaLRFEmitidasTypeRespuestaLineaItem) : gettype($respuestaLRFEmitidasTypeRespuestaLineaItem)), __LINE__);
            }
        }
        $this->RespuestaLinea = $respuestaLinea;
        return $this;
    }
    /**
     * Add item to RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaExpedidaType $item
     * @return \StructType\RespuestaLRFEmitidasType
     */
    public function addToRespuestaLinea(\StructType\RespuestaExpedidaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RespuestaExpedidaType) {
            throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaExpedidaType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RespuestaLinea[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespuestaLRFEmitidasType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
