<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaLRBienesInversionType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Respuesta a un envío Sii para suministro de Facturas emitidas
 * @subpackage Structs
 */
class RespuestaLRBienesInversionType extends RespuestaComunAltaType
{
    /**
     * The RespuestaLinea
     * Meta informations extracted from the WSDL
     * - documentation: Estado detallado de cada línea del suministro.
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var \StructType\RespuestaBienType[]
     */
    public $RespuestaLinea;
    /**
     * Constructor method for RespuestaLRBienesInversionType
     * @uses RespuestaLRBienesInversionType::setRespuestaLinea()
     * @param \StructType\RespuestaBienType[] $respuestaLinea
     */
    public function __construct(array $respuestaLinea = array())
    {
        $this
            ->setRespuestaLinea($respuestaLinea);
    }
    /**
     * Get RespuestaLinea value
     * @return \StructType\RespuestaBienType[]|null
     */
    public function getRespuestaLinea()
    {
        return $this->RespuestaLinea;
    }
    /**
     * Set RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaBienType[] $respuestaLinea
     * @return \StructType\RespuestaLRBienesInversionType
     */
    public function setRespuestaLinea(array $respuestaLinea = array())
    {
        foreach ($respuestaLinea as $respuestaLRBienesInversionTypeRespuestaLineaItem) {
            // validation for constraint: itemType
            if (!$respuestaLRBienesInversionTypeRespuestaLineaItem instanceof \StructType\RespuestaBienType) {
                throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaBienType, "%s" given', is_object($respuestaLRBienesInversionTypeRespuestaLineaItem) ? get_class($respuestaLRBienesInversionTypeRespuestaLineaItem) : gettype($respuestaLRBienesInversionTypeRespuestaLineaItem)), __LINE__);
            }
        }
        $this->RespuestaLinea = $respuestaLinea;
        return $this;
    }
    /**
     * Add item to RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaBienType $item
     * @return \StructType\RespuestaLRBienesInversionType
     */
    public function addToRespuestaLinea(\StructType\RespuestaBienType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RespuestaBienType) {
            throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaBienType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RespuestaLinea[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespuestaLRBienesInversionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
