<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaLRBajaFRecibidasPagosType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Respuesta a un envío Sii para suministro de Facturas Recibidas
 * @subpackage Structs
 */
class RespuestaLRBajaFRecibidasPagosType extends RespuestaComunBajaType
{
    /**
     * The RespuestaLinea
     * Meta informations extracted from the WSDL
     * - documentation: Estado detallado de cada línea del suministro.
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var \StructType\RespuestaRecibidaPagoType[]
     */
    public $RespuestaLinea;
    /**
     * Constructor method for RespuestaLRBajaFRecibidasPagosType
     * @uses RespuestaLRBajaFRecibidasPagosType::setRespuestaLinea()
     * @param \StructType\RespuestaRecibidaPagoType[] $respuestaLinea
     */
    public function __construct(array $respuestaLinea = array())
    {
        $this
            ->setRespuestaLinea($respuestaLinea);
    }
    /**
     * Get RespuestaLinea value
     * @return \StructType\RespuestaRecibidaPagoType[]|null
     */
    public function getRespuestaLinea()
    {
        return $this->RespuestaLinea;
    }
    /**
     * Set RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaRecibidaPagoType[] $respuestaLinea
     * @return \StructType\RespuestaLRBajaFRecibidasPagosType
     */
    public function setRespuestaLinea(array $respuestaLinea = array())
    {
        foreach ($respuestaLinea as $respuestaLRBajaFRecibidasPagosTypeRespuestaLineaItem) {
            // validation for constraint: itemType
            if (!$respuestaLRBajaFRecibidasPagosTypeRespuestaLineaItem instanceof \StructType\RespuestaRecibidaPagoType) {
                throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaRecibidaPagoType, "%s" given', is_object($respuestaLRBajaFRecibidasPagosTypeRespuestaLineaItem) ? get_class($respuestaLRBajaFRecibidasPagosTypeRespuestaLineaItem) : gettype($respuestaLRBajaFRecibidasPagosTypeRespuestaLineaItem)), __LINE__);
            }
        }
        $this->RespuestaLinea = $respuestaLinea;
        return $this;
    }
    /**
     * Add item to RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaRecibidaPagoType $item
     * @return \StructType\RespuestaLRBajaFRecibidasPagosType
     */
    public function addToRespuestaLinea(\StructType\RespuestaRecibidaPagoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RespuestaRecibidaPagoType) {
            throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaRecibidaPagoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RespuestaLinea[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespuestaLRBajaFRecibidasPagosType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
