<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaConsultaLRFacturasType StructType
 * @subpackage Structs
 */
class RespuestaConsultaLRFacturasType extends ConsultaInformacion
{
    /**
     * The PeriodoImpositivo
     * @var \StructType\PeriodoImpositivo
     */
    public $PeriodoImpositivo;
    /**
     * The IndicadorPaginacion
     * @var string
     */
    public $IndicadorPaginacion;
    /**
     * The ResultadoConsulta
     * @var string
     */
    public $ResultadoConsulta;
    /**
     * Constructor method for RespuestaConsultaLRFacturasType
     * @uses RespuestaConsultaLRFacturasType::setPeriodoImpositivo()
     * @uses RespuestaConsultaLRFacturasType::setIndicadorPaginacion()
     * @uses RespuestaConsultaLRFacturasType::setResultadoConsulta()
     * @param \StructType\PeriodoImpositivo $periodoImpositivo
     * @param string $indicadorPaginacion
     * @param string $resultadoConsulta
     */
    public function __construct(\StructType\PeriodoImpositivo $periodoImpositivo = null, $indicadorPaginacion = null, $resultadoConsulta = null)
    {
        $this
            ->setPeriodoImpositivo($periodoImpositivo)
            ->setIndicadorPaginacion($indicadorPaginacion)
            ->setResultadoConsulta($resultadoConsulta);
    }
    /**
     * Get PeriodoImpositivo value
     * @return \StructType\PeriodoImpositivo|null
     */
    public function getPeriodoImpositivo()
    {
        return $this->PeriodoImpositivo;
    }
    /**
     * Set PeriodoImpositivo value
     * @param \StructType\PeriodoImpositivo $periodoImpositivo
     * @return \StructType\RespuestaConsultaLRFacturasType
     */
    public function setPeriodoImpositivo(\StructType\PeriodoImpositivo $periodoImpositivo = null)
    {
        $this->PeriodoImpositivo = $periodoImpositivo;
        return $this;
    }
    /**
     * Get IndicadorPaginacion value
     * @return string|null
     */
    public function getIndicadorPaginacion()
    {
        return $this->IndicadorPaginacion;
    }
    /**
     * Set IndicadorPaginacion value
     * @uses \EnumType\IndicadorPaginacionType::valueIsValid()
     * @uses \EnumType\IndicadorPaginacionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $indicadorPaginacion
     * @return \StructType\RespuestaConsultaLRFacturasType
     */
    public function setIndicadorPaginacion($indicadorPaginacion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndicadorPaginacionType::valueIsValid($indicadorPaginacion)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $indicadorPaginacion, implode(', ', \EnumType\IndicadorPaginacionType::getValidValues())), __LINE__);
        }
        $this->IndicadorPaginacion = $indicadorPaginacion;
        return $this;
    }
    /**
     * Get ResultadoConsulta value
     * @return string|null
     */
    public function getResultadoConsulta()
    {
        return $this->ResultadoConsulta;
    }
    /**
     * Set ResultadoConsulta value
     * @uses \EnumType\ResultadoConsultaType::valueIsValid()
     * @uses \EnumType\ResultadoConsultaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultadoConsulta
     * @return \StructType\RespuestaConsultaLRFacturasType
     */
    public function setResultadoConsulta($resultadoConsulta = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResultadoConsultaType::valueIsValid($resultadoConsulta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resultadoConsulta, implode(', ', \EnumType\ResultadoConsultaType::getValidValues())), __LINE__);
        }
        $this->ResultadoConsulta = $resultadoConsulta;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespuestaConsultaLRFacturasType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
