<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonaFisicaJuridicaESType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Datos de una persona física o jurídica Española con un NIF asociado
 * @subpackage Structs
 */
class PersonaFisicaJuridicaESType extends AbstractStructBase
{
    /**
     * The NombreRazon
     * Meta informations extracted from the WSDL
     * - maxLength: 40
     * @var string
     */
    public $NombreRazon;
    /**
     * The NIFRepresentante
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: NIF: Secuencia de 9 dígitos o letras mayúsculas
     * - length: 9
     * - pattern: (([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))
     * @var string
     */
    public $NIFRepresentante;
    /**
     * The NIF
     * Meta informations extracted from the WSDL
     * - documentation: NIF: Secuencia de 9 dígitos o letras mayúsculas
     * - length: 9
     * - pattern: (([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))
     * @var string
     */
    public $NIF;
    /**
     * Constructor method for PersonaFisicaJuridicaESType
     * @uses PersonaFisicaJuridicaESType::setNombreRazon()
     * @uses PersonaFisicaJuridicaESType::setNIFRepresentante()
     * @uses PersonaFisicaJuridicaESType::setNIF()
     * @param string $nombreRazon
     * @param string $nIFRepresentante
     * @param string $nIF
     */
    public function __construct($nombreRazon = null, $nIFRepresentante = null, $nIF = null)
    {
        $this
            ->setNombreRazon($nombreRazon)
            ->setNIFRepresentante($nIFRepresentante)
            ->setNIF($nIF);
    }
    /**
     * Get NombreRazon value
     * @return string|null
     */
    public function getNombreRazon()
    {
        return $this->NombreRazon;
    }
    /**
     * Set NombreRazon value
     * @param string $nombreRazon
     * @return \StructType\PersonaFisicaJuridicaESType
     */
    public function setNombreRazon($nombreRazon = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nombreRazon) && strlen($nombreRazon) > 40) || (is_array($nombreRazon) && count($nombreRazon) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($nombreRazon) ? strlen($nombreRazon) : count($nombreRazon)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nombreRazon) && !is_string($nombreRazon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombreRazon)), __LINE__);
        }
        $this->NombreRazon = $nombreRazon;
        return $this;
    }
    /**
     * Get NIFRepresentante value
     * @return string|null
     */
    public function getNIFRepresentante()
    {
        return $this->NIFRepresentante;
    }
    /**
     * Set NIFRepresentante value
     * @param string $nIFRepresentante
     * @return \StructType\PersonaFisicaJuridicaESType
     */
    public function setNIFRepresentante($nIFRepresentante = null)
    {
        // validation for constraint: length
        if ((is_scalar($nIFRepresentante) && strlen($nIFRepresentante) !== 9) || (is_array($nIFRepresentante) && count($nIFRepresentante) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($nIFRepresentante) && !preg_match('/(([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))/', $nIFRepresentante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))", "%s" given', var_export($nIFRepresentante, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nIFRepresentante) && !is_string($nIFRepresentante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nIFRepresentante)), __LINE__);
        }
        $this->NIFRepresentante = $nIFRepresentante;
        return $this;
    }
    /**
     * Get NIF value
     * @return string|null
     */
    public function getNIF()
    {
        return $this->NIF;
    }
    /**
     * Set NIF value
     * @param string $nIF
     * @return \StructType\PersonaFisicaJuridicaESType
     */
    public function setNIF($nIF = null)
    {
        // validation for constraint: length
        if ((is_scalar($nIF) && strlen($nIF) !== 9) || (is_array($nIF) && count($nIF) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($nIF) && !preg_match('/(([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))/', $nIF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))", "%s" given', var_export($nIF, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nIF) && !is_string($nIF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nIF)), __LINE__);
        }
        $this->NIF = $nIF;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonaFisicaJuridicaESType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
