<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoExenta StructType
 * @subpackage Structs
 */
class NoExenta extends AbstractStructBase
{
    /**
     * The TipoNoExenta
     * @var string
     */
    public $TipoNoExenta;
    /**
     * The DesgloseIVA
     * @var \StructType\DesgloseIVA
     */
    public $DesgloseIVA;
    /**
     * Constructor method for NoExenta
     * @uses NoExenta::setTipoNoExenta()
     * @uses NoExenta::setDesgloseIVA()
     * @param string $tipoNoExenta
     * @param \StructType\DesgloseIVA $desgloseIVA
     */
    public function __construct($tipoNoExenta = null, \StructType\DesgloseIVA $desgloseIVA = null)
    {
        $this
            ->setTipoNoExenta($tipoNoExenta)
            ->setDesgloseIVA($desgloseIVA);
    }
    /**
     * Get TipoNoExenta value
     * @return string|null
     */
    public function getTipoNoExenta()
    {
        return $this->TipoNoExenta;
    }
    /**
     * Set TipoNoExenta value
     * @uses \EnumType\TipoOperacionSujetaNoExentaType::valueIsValid()
     * @uses \EnumType\TipoOperacionSujetaNoExentaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoNoExenta
     * @return \StructType\NoExenta
     */
    public function setTipoNoExenta($tipoNoExenta = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoOperacionSujetaNoExentaType::valueIsValid($tipoNoExenta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoNoExenta, implode(', ', \EnumType\TipoOperacionSujetaNoExentaType::getValidValues())), __LINE__);
        }
        $this->TipoNoExenta = $tipoNoExenta;
        return $this;
    }
    /**
     * Get DesgloseIVA value
     * @return \StructType\DesgloseIVA|null
     */
    public function getDesgloseIVA()
    {
        return $this->DesgloseIVA;
    }
    /**
     * Set DesgloseIVA value
     * @param \StructType\DesgloseIVA $desgloseIVA
     * @return \StructType\NoExenta
     */
    public function setDesgloseIVA(\StructType\DesgloseIVA $desgloseIVA = null)
    {
        $this->DesgloseIVA = $desgloseIVA;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NoExenta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
