<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LROperacionIntracomunitariaType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Apunte correspondiente al libro de operaciones intracomunitarias.
 * @subpackage Structs
 */
class LROperacionIntracomunitariaType extends RegistroSii
{
    /**
     * The IDFactura
     * @var \StructType\IDFacturaComunitariaType
     */
    public $IDFactura;
    /**
     * The Contraparte
     * Meta informations extracted from the WSDL
     * - documentation: Contraparte de la operación. Cliente en facturas emitidas. Proveedor en facturas recibidas.
     * @var \StructType\PersonaFisicaJuridicaType
     */
    public $Contraparte;
    /**
     * The OperacionIntracomunitaria
     * Meta informations extracted from the WSDL
     * - documentation: Apunte correspondiente al libro de operaciones intracomunitarias.
     * @var \StructType\OperacionIntracomunitariaType
     */
    public $OperacionIntracomunitaria;
    /**
     * Constructor method for LROperacionIntracomunitariaType
     * @uses LROperacionIntracomunitariaType::setIDFactura()
     * @uses LROperacionIntracomunitariaType::setContraparte()
     * @uses LROperacionIntracomunitariaType::setOperacionIntracomunitaria()
     * @param \StructType\IDFacturaComunitariaType $iDFactura
     * @param \StructType\PersonaFisicaJuridicaType $contraparte
     * @param \StructType\OperacionIntracomunitariaType $operacionIntracomunitaria
     */
    public function __construct(\StructType\IDFacturaComunitariaType $iDFactura = null, \StructType\PersonaFisicaJuridicaType $contraparte = null, \StructType\OperacionIntracomunitariaType $operacionIntracomunitaria = null)
    {
        $this
            ->setIDFactura($iDFactura)
            ->setContraparte($contraparte)
            ->setOperacionIntracomunitaria($operacionIntracomunitaria);
    }
    /**
     * Get IDFactura value
     * @return \StructType\IDFacturaComunitariaType|null
     */
    public function getIDFactura()
    {
        return $this->IDFactura;
    }
    /**
     * Set IDFactura value
     * @param \StructType\IDFacturaComunitariaType $iDFactura
     * @return \StructType\LROperacionIntracomunitariaType
     */
    public function setIDFactura(\StructType\IDFacturaComunitariaType $iDFactura = null)
    {
        $this->IDFactura = $iDFactura;
        return $this;
    }
    /**
     * Get Contraparte value
     * @return \StructType\PersonaFisicaJuridicaType|null
     */
    public function getContraparte()
    {
        return $this->Contraparte;
    }
    /**
     * Set Contraparte value
     * @param \StructType\PersonaFisicaJuridicaType $contraparte
     * @return \StructType\LROperacionIntracomunitariaType
     */
    public function setContraparte(\StructType\PersonaFisicaJuridicaType $contraparte = null)
    {
        $this->Contraparte = $contraparte;
        return $this;
    }
    /**
     * Get OperacionIntracomunitaria value
     * @return \StructType\OperacionIntracomunitariaType|null
     */
    public function getOperacionIntracomunitaria()
    {
        return $this->OperacionIntracomunitaria;
    }
    /**
     * Set OperacionIntracomunitaria value
     * @param \StructType\OperacionIntracomunitariaType $operacionIntracomunitaria
     * @return \StructType\LROperacionIntracomunitariaType
     */
    public function setOperacionIntracomunitaria(\StructType\OperacionIntracomunitariaType $operacionIntracomunitaria = null)
    {
        $this->OperacionIntracomunitaria = $operacionIntracomunitaria;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LROperacionIntracomunitariaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
