<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRCobrosMetalicoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Apunte correspondiente al libro de importes recibidos en metalico.
 * @subpackage Structs
 */
class LRCobrosMetalicoType extends RegistroSii
{
    /**
     * The Contraparte
     * Meta informations extracted from the WSDL
     * - documentation: Contraparte de la operación. Cliente en facturas emitidas. Proveedor en facturas recibidas.
     * @var \StructType\PersonaFisicaJuridicaType
     */
    public $Contraparte;
    /**
     * The ImporteTotal
     * Meta informations extracted from the WSDL
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $ImporteTotal;
    /**
     * Constructor method for LRCobrosMetalicoType
     * @uses LRCobrosMetalicoType::setContraparte()
     * @uses LRCobrosMetalicoType::setImporteTotal()
     * @param \StructType\PersonaFisicaJuridicaType $contraparte
     * @param string $importeTotal
     */
    public function __construct(\StructType\PersonaFisicaJuridicaType $contraparte = null, $importeTotal = null)
    {
        $this
            ->setContraparte($contraparte)
            ->setImporteTotal($importeTotal);
    }
    /**
     * Get Contraparte value
     * @return \StructType\PersonaFisicaJuridicaType|null
     */
    public function getContraparte()
    {
        return $this->Contraparte;
    }
    /**
     * Set Contraparte value
     * @param \StructType\PersonaFisicaJuridicaType $contraparte
     * @return \StructType\LRCobrosMetalicoType
     */
    public function setContraparte(\StructType\PersonaFisicaJuridicaType $contraparte = null)
    {
        $this->Contraparte = $contraparte;
        return $this;
    }
    /**
     * Get ImporteTotal value
     * @return string|null
     */
    public function getImporteTotal()
    {
        return $this->ImporteTotal;
    }
    /**
     * Set ImporteTotal value
     * @param string $importeTotal
     * @return \StructType\LRCobrosMetalicoType
     */
    public function setImporteTotal($importeTotal = null)
    {
        // validation for constraint: pattern
        if (is_scalar($importeTotal) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $importeTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($importeTotal, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($importeTotal) && !is_string($importeTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importeTotal)), __LINE__);
        }
        $this->ImporteTotal = $importeTotal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LRCobrosMetalicoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
