<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IDFacturaRecibidaType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Datos de identificación de factura
 * @subpackage Structs
 */
class IDFacturaRecibidaType extends AbstractStructBase
{
    /**
     * The IDEmisorFactura
     * @var \StructType\IDEmisorFactura
     */
    public $IDEmisorFactura;
    /**
     * The NumSerieFacturaEmisor
     * Meta informations extracted from the WSDL
     * - documentation: Número de la Factura del Emisor. En caso de asientos resúmenes número inicial de factura
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $NumSerieFacturaEmisor;
    /**
     * The NumSerieFacturaEmisorResumenFin
     * Meta informations extracted from the WSDL
     * - documentation: Campo específico para asientos resumen. Se corresponde con el número y serie de la última factura
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $NumSerieFacturaEmisorResumenFin;
    /**
     * The FechaExpedicionFacturaEmisor
     * Meta informations extracted from the WSDL
     * - documentation: Fecha de emisión de la factura
     * - length: 10
     * - pattern: \d{2,2}-\d{2,2}-\d{4,4}
     * @var string
     */
    public $FechaExpedicionFacturaEmisor;
    /**
     * Constructor method for IDFacturaRecibidaType
     * @uses IDFacturaRecibidaType::setIDEmisorFactura()
     * @uses IDFacturaRecibidaType::setNumSerieFacturaEmisor()
     * @uses IDFacturaRecibidaType::setNumSerieFacturaEmisorResumenFin()
     * @uses IDFacturaRecibidaType::setFechaExpedicionFacturaEmisor()
     * @param \StructType\IDEmisorFactura $iDEmisorFactura
     * @param string $numSerieFacturaEmisor
     * @param string $numSerieFacturaEmisorResumenFin
     * @param string $fechaExpedicionFacturaEmisor
     */
    public function __construct(\StructType\IDEmisorFactura $iDEmisorFactura = null, $numSerieFacturaEmisor = null, $numSerieFacturaEmisorResumenFin = null, $fechaExpedicionFacturaEmisor = null)
    {
        $this
            ->setIDEmisorFactura($iDEmisorFactura)
            ->setNumSerieFacturaEmisor($numSerieFacturaEmisor)
            ->setNumSerieFacturaEmisorResumenFin($numSerieFacturaEmisorResumenFin)
            ->setFechaExpedicionFacturaEmisor($fechaExpedicionFacturaEmisor);
    }
    /**
     * Get IDEmisorFactura value
     * @return \StructType\IDEmisorFactura|null
     */
    public function getIDEmisorFactura()
    {
        return $this->IDEmisorFactura;
    }
    /**
     * Set IDEmisorFactura value
     * @param \StructType\IDEmisorFactura $iDEmisorFactura
     * @return \StructType\IDFacturaRecibidaType
     */
    public function setIDEmisorFactura(\StructType\IDEmisorFactura $iDEmisorFactura = null)
    {
        $this->IDEmisorFactura = $iDEmisorFactura;
        return $this;
    }
    /**
     * Get NumSerieFacturaEmisor value
     * @return string|null
     */
    public function getNumSerieFacturaEmisor()
    {
        return $this->NumSerieFacturaEmisor;
    }
    /**
     * Set NumSerieFacturaEmisor value
     * @param string $numSerieFacturaEmisor
     * @return \StructType\IDFacturaRecibidaType
     */
    public function setNumSerieFacturaEmisor($numSerieFacturaEmisor = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numSerieFacturaEmisor) && strlen($numSerieFacturaEmisor) > 60) || (is_array($numSerieFacturaEmisor) && count($numSerieFacturaEmisor) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($numSerieFacturaEmisor) ? strlen($numSerieFacturaEmisor) : count($numSerieFacturaEmisor)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numSerieFacturaEmisor) && strlen($numSerieFacturaEmisor) < 1) || (is_array($numSerieFacturaEmisor) && count($numSerieFacturaEmisor) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numSerieFacturaEmisor) && !is_string($numSerieFacturaEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numSerieFacturaEmisor)), __LINE__);
        }
        $this->NumSerieFacturaEmisor = $numSerieFacturaEmisor;
        return $this;
    }
    /**
     * Get NumSerieFacturaEmisorResumenFin value
     * @return string|null
     */
    public function getNumSerieFacturaEmisorResumenFin()
    {
        return $this->NumSerieFacturaEmisorResumenFin;
    }
    /**
     * Set NumSerieFacturaEmisorResumenFin value
     * @param string $numSerieFacturaEmisorResumenFin
     * @return \StructType\IDFacturaRecibidaType
     */
    public function setNumSerieFacturaEmisorResumenFin($numSerieFacturaEmisorResumenFin = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numSerieFacturaEmisorResumenFin) && strlen($numSerieFacturaEmisorResumenFin) > 60) || (is_array($numSerieFacturaEmisorResumenFin) && count($numSerieFacturaEmisorResumenFin) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($numSerieFacturaEmisorResumenFin) ? strlen($numSerieFacturaEmisorResumenFin) : count($numSerieFacturaEmisorResumenFin)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numSerieFacturaEmisorResumenFin) && strlen($numSerieFacturaEmisorResumenFin) < 1) || (is_array($numSerieFacturaEmisorResumenFin) && count($numSerieFacturaEmisorResumenFin) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numSerieFacturaEmisorResumenFin) && !is_string($numSerieFacturaEmisorResumenFin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numSerieFacturaEmisorResumenFin)), __LINE__);
        }
        $this->NumSerieFacturaEmisorResumenFin = $numSerieFacturaEmisorResumenFin;
        return $this;
    }
    /**
     * Get FechaExpedicionFacturaEmisor value
     * @return string|null
     */
    public function getFechaExpedicionFacturaEmisor()
    {
        return $this->FechaExpedicionFacturaEmisor;
    }
    /**
     * Set FechaExpedicionFacturaEmisor value
     * @param string $fechaExpedicionFacturaEmisor
     * @return \StructType\IDFacturaRecibidaType
     */
    public function setFechaExpedicionFacturaEmisor($fechaExpedicionFacturaEmisor = null)
    {
        // validation for constraint: length
        if ((is_scalar($fechaExpedicionFacturaEmisor) && strlen($fechaExpedicionFacturaEmisor) !== 10) || (is_array($fechaExpedicionFacturaEmisor) && count($fechaExpedicionFacturaEmisor) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($fechaExpedicionFacturaEmisor) && !preg_match('/\d{2,2}-\d{2,2}-\d{4,4}/', $fechaExpedicionFacturaEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{2,2}-\d{2,2}-\d{4,4}", "%s" given', var_export($fechaExpedicionFacturaEmisor, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fechaExpedicionFacturaEmisor) && !is_string($fechaExpedicionFacturaEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaExpedicionFacturaEmisor)), __LINE__);
        }
        $this->FechaExpedicionFacturaEmisor = $fechaExpedicionFacturaEmisor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IDFacturaRecibidaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
