<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacturaType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Datos comunes de facturas emitidas y recibidas
 * @subpackage Structs
 */
class FacturaType extends AbstractStructBase
{
    /**
     * The TipoFactura
     * Meta informations extracted from the WSDL
     * - documentation: Clave del tipo de factura
     * @var string
     */
    public $TipoFactura;
    /**
     * The TipoRectificativa
     * Meta informations extracted from the WSDL
     * - documentation: Clave del tipo de factura
     * - minOccurs: 0
     * @var string
     */
    public $TipoRectificativa;
    /**
     * The FacturasAgrupadas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FacturasAgrupadas
     */
    public $FacturasAgrupadas;
    /**
     * The FacturasRectificadas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FacturasRectificadas
     */
    public $FacturasRectificadas;
    /**
     * The ImporteRectificacion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DesgloseRectificacionType
     */
    public $ImporteRectificacion;
    /**
     * The FechaOperacion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 10
     * - pattern: \d{2,2}-\d{2,2}-\d{4,4}
     * @var string
     */
    public $FechaOperacion;
    /**
     * The ClaveRegimenEspecialOTrascendencia
     * @var string
     */
    public $ClaveRegimenEspecialOTrascendencia;
    /**
     * The ImporteTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $ImporteTotal;
    /**
     * The BaseImponibleACoste
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $BaseImponibleACoste;
    /**
     * The DescripcionOperacion
     * Meta informations extracted from the WSDL
     * - maxLength: 500
     * @var string
     */
    public $DescripcionOperacion;
    /**
     * Constructor method for FacturaType
     * @uses FacturaType::setTipoFactura()
     * @uses FacturaType::setTipoRectificativa()
     * @uses FacturaType::setFacturasAgrupadas()
     * @uses FacturaType::setFacturasRectificadas()
     * @uses FacturaType::setImporteRectificacion()
     * @uses FacturaType::setFechaOperacion()
     * @uses FacturaType::setClaveRegimenEspecialOTrascendencia()
     * @uses FacturaType::setImporteTotal()
     * @uses FacturaType::setBaseImponibleACoste()
     * @uses FacturaType::setDescripcionOperacion()
     * @param string $tipoFactura
     * @param string $tipoRectificativa
     * @param \StructType\FacturasAgrupadas $facturasAgrupadas
     * @param \StructType\FacturasRectificadas $facturasRectificadas
     * @param \StructType\DesgloseRectificacionType $importeRectificacion
     * @param string $fechaOperacion
     * @param string $claveRegimenEspecialOTrascendencia
     * @param string $importeTotal
     * @param string $baseImponibleACoste
     * @param string $descripcionOperacion
     */
    public function __construct($tipoFactura = null, $tipoRectificativa = null, \StructType\FacturasAgrupadas $facturasAgrupadas = null, \StructType\FacturasRectificadas $facturasRectificadas = null, \StructType\DesgloseRectificacionType $importeRectificacion = null, $fechaOperacion = null, $claveRegimenEspecialOTrascendencia = null, $importeTotal = null, $baseImponibleACoste = null, $descripcionOperacion = null)
    {
        $this
            ->setTipoFactura($tipoFactura)
            ->setTipoRectificativa($tipoRectificativa)
            ->setFacturasAgrupadas($facturasAgrupadas)
            ->setFacturasRectificadas($facturasRectificadas)
            ->setImporteRectificacion($importeRectificacion)
            ->setFechaOperacion($fechaOperacion)
            ->setClaveRegimenEspecialOTrascendencia($claveRegimenEspecialOTrascendencia)
            ->setImporteTotal($importeTotal)
            ->setBaseImponibleACoste($baseImponibleACoste)
            ->setDescripcionOperacion($descripcionOperacion);
    }
    /**
     * Get TipoFactura value
     * @return string|null
     */
    public function getTipoFactura()
    {
        return $this->TipoFactura;
    }
    /**
     * Set TipoFactura value
     * @uses \EnumType\ClaveTipoFacturaType::valueIsValid()
     * @uses \EnumType\ClaveTipoFacturaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoFactura
     * @return \StructType\FacturaType
     */
    public function setTipoFactura($tipoFactura = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClaveTipoFacturaType::valueIsValid($tipoFactura)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoFactura, implode(', ', \EnumType\ClaveTipoFacturaType::getValidValues())), __LINE__);
        }
        $this->TipoFactura = $tipoFactura;
        return $this;
    }
    /**
     * Get TipoRectificativa value
     * @return string|null
     */
    public function getTipoRectificativa()
    {
        return $this->TipoRectificativa;
    }
    /**
     * Set TipoRectificativa value
     * @uses \EnumType\ClaveTipoRectificativaType::valueIsValid()
     * @uses \EnumType\ClaveTipoRectificativaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoRectificativa
     * @return \StructType\FacturaType
     */
    public function setTipoRectificativa($tipoRectificativa = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClaveTipoRectificativaType::valueIsValid($tipoRectificativa)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoRectificativa, implode(', ', \EnumType\ClaveTipoRectificativaType::getValidValues())), __LINE__);
        }
        $this->TipoRectificativa = $tipoRectificativa;
        return $this;
    }
    /**
     * Get FacturasAgrupadas value
     * @return \StructType\FacturasAgrupadas|null
     */
    public function getFacturasAgrupadas()
    {
        return $this->FacturasAgrupadas;
    }
    /**
     * Set FacturasAgrupadas value
     * @param \StructType\FacturasAgrupadas $facturasAgrupadas
     * @return \StructType\FacturaType
     */
    public function setFacturasAgrupadas(\StructType\FacturasAgrupadas $facturasAgrupadas = null)
    {
        $this->FacturasAgrupadas = $facturasAgrupadas;
        return $this;
    }
    /**
     * Get FacturasRectificadas value
     * @return \StructType\FacturasRectificadas|null
     */
    public function getFacturasRectificadas()
    {
        return $this->FacturasRectificadas;
    }
    /**
     * Set FacturasRectificadas value
     * @param \StructType\FacturasRectificadas $facturasRectificadas
     * @return \StructType\FacturaType
     */
    public function setFacturasRectificadas(\StructType\FacturasRectificadas $facturasRectificadas = null)
    {
        $this->FacturasRectificadas = $facturasRectificadas;
        return $this;
    }
    /**
     * Get ImporteRectificacion value
     * @return \StructType\DesgloseRectificacionType|null
     */
    public function getImporteRectificacion()
    {
        return $this->ImporteRectificacion;
    }
    /**
     * Set ImporteRectificacion value
     * @param \StructType\DesgloseRectificacionType $importeRectificacion
     * @return \StructType\FacturaType
     */
    public function setImporteRectificacion(\StructType\DesgloseRectificacionType $importeRectificacion = null)
    {
        $this->ImporteRectificacion = $importeRectificacion;
        return $this;
    }
    /**
     * Get FechaOperacion value
     * @return string|null
     */
    public function getFechaOperacion()
    {
        return $this->FechaOperacion;
    }
    /**
     * Set FechaOperacion value
     * @param string $fechaOperacion
     * @return \StructType\FacturaType
     */
    public function setFechaOperacion($fechaOperacion = null)
    {
        // validation for constraint: length
        if ((is_scalar($fechaOperacion) && strlen($fechaOperacion) !== 10) || (is_array($fechaOperacion) && count($fechaOperacion) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($fechaOperacion) && !preg_match('/\d{2,2}-\d{2,2}-\d{4,4}/', $fechaOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{2,2}-\d{2,2}-\d{4,4}", "%s" given', var_export($fechaOperacion, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fechaOperacion) && !is_string($fechaOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaOperacion)), __LINE__);
        }
        $this->FechaOperacion = $fechaOperacion;
        return $this;
    }
    /**
     * Get ClaveRegimenEspecialOTrascendencia value
     * @return string|null
     */
    public function getClaveRegimenEspecialOTrascendencia()
    {
        return $this->ClaveRegimenEspecialOTrascendencia;
    }
    /**
     * Set ClaveRegimenEspecialOTrascendencia value
     * @uses \EnumType\IdOperacionesTrascendenciaTributariaType::valueIsValid()
     * @uses \EnumType\IdOperacionesTrascendenciaTributariaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claveRegimenEspecialOTrascendencia
     * @return \StructType\FacturaType
     */
    public function setClaveRegimenEspecialOTrascendencia($claveRegimenEspecialOTrascendencia = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IdOperacionesTrascendenciaTributariaType::valueIsValid($claveRegimenEspecialOTrascendencia)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $claveRegimenEspecialOTrascendencia, implode(', ', \EnumType\IdOperacionesTrascendenciaTributariaType::getValidValues())), __LINE__);
        }
        $this->ClaveRegimenEspecialOTrascendencia = $claveRegimenEspecialOTrascendencia;
        return $this;
    }
    /**
     * Get ImporteTotal value
     * @return string|null
     */
    public function getImporteTotal()
    {
        return $this->ImporteTotal;
    }
    /**
     * Set ImporteTotal value
     * @param string $importeTotal
     * @return \StructType\FacturaType
     */
    public function setImporteTotal($importeTotal = null)
    {
        // validation for constraint: pattern
        if (is_scalar($importeTotal) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $importeTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($importeTotal, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($importeTotal) && !is_string($importeTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importeTotal)), __LINE__);
        }
        $this->ImporteTotal = $importeTotal;
        return $this;
    }
    /**
     * Get BaseImponibleACoste value
     * @return string|null
     */
    public function getBaseImponibleACoste()
    {
        return $this->BaseImponibleACoste;
    }
    /**
     * Set BaseImponibleACoste value
     * @param string $baseImponibleACoste
     * @return \StructType\FacturaType
     */
    public function setBaseImponibleACoste($baseImponibleACoste = null)
    {
        // validation for constraint: pattern
        if (is_scalar($baseImponibleACoste) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $baseImponibleACoste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($baseImponibleACoste, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($baseImponibleACoste) && !is_string($baseImponibleACoste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseImponibleACoste)), __LINE__);
        }
        $this->BaseImponibleACoste = $baseImponibleACoste;
        return $this;
    }
    /**
     * Get DescripcionOperacion value
     * @return string|null
     */
    public function getDescripcionOperacion()
    {
        return $this->DescripcionOperacion;
    }
    /**
     * Set DescripcionOperacion value
     * @param string $descripcionOperacion
     * @return \StructType\FacturaType
     */
    public function setDescripcionOperacion($descripcionOperacion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descripcionOperacion) && strlen($descripcionOperacion) > 500) || (is_array($descripcionOperacion) && count($descripcionOperacion) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($descripcionOperacion) ? strlen($descripcionOperacion) : count($descripcionOperacion)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descripcionOperacion) && !is_string($descripcionOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descripcionOperacion)), __LINE__);
        }
        $this->DescripcionOperacion = $descripcionOperacion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacturaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
