<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacturaRecibidaType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Apunte correspondiente al libro de facturas recibidas.
 * @subpackage Structs
 */
class FacturaRecibidaType extends FacturaType
{
    /**
     * The Aduanas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AduanasType
     */
    public $Aduanas;
    /**
     * The NoExenta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NoExentaRecibidasType
     */
    public $NoExenta;
    /**
     * The Contraparte
     * Meta informations extracted from the WSDL
     * - documentation: Contraparte de la operación. Proveedor (Obligatorio) en facturas recibidas.
     * @var \StructType\PersonaFisicaJuridicaType
     */
    public $Contraparte;
    /**
     * The FechaRegContable
     * Meta informations extracted from the WSDL
     * - length: 10
     * - pattern: \d{2,2}-\d{2,2}-\d{4,4}
     * @var string
     */
    public $FechaRegContable;
    /**
     * The CuotaDeducible
     * Meta informations extracted from the WSDL
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $CuotaDeducible;
    /**
     * Constructor method for FacturaRecibidaType
     * @uses FacturaRecibidaType::setAduanas()
     * @uses FacturaRecibidaType::setNoExenta()
     * @uses FacturaRecibidaType::setContraparte()
     * @uses FacturaRecibidaType::setFechaRegContable()
     * @uses FacturaRecibidaType::setCuotaDeducible()
     * @param \StructType\AduanasType $aduanas
     * @param \StructType\NoExentaRecibidasType $noExenta
     * @param \StructType\PersonaFisicaJuridicaType $contraparte
     * @param string $fechaRegContable
     * @param string $cuotaDeducible
     */
    public function __construct(\StructType\AduanasType $aduanas = null, \StructType\NoExentaRecibidasType $noExenta = null, \StructType\PersonaFisicaJuridicaType $contraparte = null, $fechaRegContable = null, $cuotaDeducible = null)
    {
        $this
            ->setAduanas($aduanas)
            ->setNoExenta($noExenta)
            ->setContraparte($contraparte)
            ->setFechaRegContable($fechaRegContable)
            ->setCuotaDeducible($cuotaDeducible);
    }
    /**
     * Get Aduanas value
     * @return \StructType\AduanasType|null
     */
    public function getAduanas()
    {
        return $this->Aduanas;
    }
    /**
     * Set Aduanas value
     * @param \StructType\AduanasType $aduanas
     * @return \StructType\FacturaRecibidaType
     */
    public function setAduanas(\StructType\AduanasType $aduanas = null)
    {
        $this->Aduanas = $aduanas;
        return $this;
    }
    /**
     * Get NoExenta value
     * @return \StructType\NoExentaRecibidasType|null
     */
    public function getNoExenta()
    {
        return $this->NoExenta;
    }
    /**
     * Set NoExenta value
     * @param \StructType\NoExentaRecibidasType $noExenta
     * @return \StructType\FacturaRecibidaType
     */
    public function setNoExenta(\StructType\NoExentaRecibidasType $noExenta = null)
    {
        $this->NoExenta = $noExenta;
        return $this;
    }
    /**
     * Get Contraparte value
     * @return \StructType\PersonaFisicaJuridicaType|null
     */
    public function getContraparte()
    {
        return $this->Contraparte;
    }
    /**
     * Set Contraparte value
     * @param \StructType\PersonaFisicaJuridicaType $contraparte
     * @return \StructType\FacturaRecibidaType
     */
    public function setContraparte(\StructType\PersonaFisicaJuridicaType $contraparte = null)
    {
        $this->Contraparte = $contraparte;
        return $this;
    }
    /**
     * Get FechaRegContable value
     * @return string|null
     */
    public function getFechaRegContable()
    {
        return $this->FechaRegContable;
    }
    /**
     * Set FechaRegContable value
     * @param string $fechaRegContable
     * @return \StructType\FacturaRecibidaType
     */
    public function setFechaRegContable($fechaRegContable = null)
    {
        // validation for constraint: length
        if ((is_scalar($fechaRegContable) && strlen($fechaRegContable) !== 10) || (is_array($fechaRegContable) && count($fechaRegContable) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($fechaRegContable) && !preg_match('/\d{2,2}-\d{2,2}-\d{4,4}/', $fechaRegContable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{2,2}-\d{2,2}-\d{4,4}", "%s" given', var_export($fechaRegContable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fechaRegContable) && !is_string($fechaRegContable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaRegContable)), __LINE__);
        }
        $this->FechaRegContable = $fechaRegContable;
        return $this;
    }
    /**
     * Get CuotaDeducible value
     * @return string|null
     */
    public function getCuotaDeducible()
    {
        return $this->CuotaDeducible;
    }
    /**
     * Set CuotaDeducible value
     * @param string $cuotaDeducible
     * @return \StructType\FacturaRecibidaType
     */
    public function setCuotaDeducible($cuotaDeducible = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cuotaDeducible) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $cuotaDeducible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($cuotaDeducible, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cuotaDeducible) && !is_string($cuotaDeducible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cuotaDeducible)), __LINE__);
        }
        $this->CuotaDeducible = $cuotaDeducible;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacturaRecibidaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
