<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstadoFacturaType StructType
 * @subpackage Structs
 */
class EstadoFacturaType extends AbstractStructBase
{
    /**
     * The TimestampUltimaModificacion
     * Meta informations extracted from the WSDL
     * - length: 19
     * - pattern: \d{2,2}-\d{2,2}-\d{4,4} \d{2,2}:\d{2,2}:\d{2,2}
     * @var string
     */
    public $TimestampUltimaModificacion;
    /**
     * The EstadoRegistro
     * Meta informations extracted from the WSDL
     * - maxLength: 40
     * @var string
     */
    public $EstadoRegistro;
    /**
     * The CodigoErrorRegistro
     * Meta informations extracted from the WSDL
     * - documentation: Código del error de registro, en su caso.
     * - minOccurs: 0
     * @var int
     */
    public $CodigoErrorRegistro;
    /**
     * The DescripcionErrorRegistro
     * Meta informations extracted from the WSDL
     * - documentation: Descripción detallada del error de registro, en su caso.
     * - minOccurs: 0
     * - maxLength: 500
     * @var string
     */
    public $DescripcionErrorRegistro;
    /**
     * Constructor method for EstadoFacturaType
     * @uses EstadoFacturaType::setTimestampUltimaModificacion()
     * @uses EstadoFacturaType::setEstadoRegistro()
     * @uses EstadoFacturaType::setCodigoErrorRegistro()
     * @uses EstadoFacturaType::setDescripcionErrorRegistro()
     * @param string $timestampUltimaModificacion
     * @param string $estadoRegistro
     * @param int $codigoErrorRegistro
     * @param string $descripcionErrorRegistro
     */
    public function __construct($timestampUltimaModificacion = null, $estadoRegistro = null, $codigoErrorRegistro = null, $descripcionErrorRegistro = null)
    {
        $this
            ->setTimestampUltimaModificacion($timestampUltimaModificacion)
            ->setEstadoRegistro($estadoRegistro)
            ->setCodigoErrorRegistro($codigoErrorRegistro)
            ->setDescripcionErrorRegistro($descripcionErrorRegistro);
    }
    /**
     * Get TimestampUltimaModificacion value
     * @return string|null
     */
    public function getTimestampUltimaModificacion()
    {
        return $this->TimestampUltimaModificacion;
    }
    /**
     * Set TimestampUltimaModificacion value
     * @param string $timestampUltimaModificacion
     * @return \StructType\EstadoFacturaType
     */
    public function setTimestampUltimaModificacion($timestampUltimaModificacion = null)
    {
        // validation for constraint: length
        if ((is_scalar($timestampUltimaModificacion) && strlen($timestampUltimaModificacion) !== 19) || (is_array($timestampUltimaModificacion) && count($timestampUltimaModificacion) !== 19)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 19 element(s) or a scalar of 19 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($timestampUltimaModificacion) && !preg_match('/\d{2,2}-\d{2,2}-\d{4,4} \d{2,2}:\d{2,2}:\d{2,2}/', $timestampUltimaModificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{2,2}-\d{2,2}-\d{4,4} \d{2,2}:\d{2,2}:\d{2,2}", "%s" given', var_export($timestampUltimaModificacion, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($timestampUltimaModificacion) && !is_string($timestampUltimaModificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestampUltimaModificacion)), __LINE__);
        }
        $this->TimestampUltimaModificacion = $timestampUltimaModificacion;
        return $this;
    }
    /**
     * Get EstadoRegistro value
     * @return string|null
     */
    public function getEstadoRegistro()
    {
        return $this->EstadoRegistro;
    }
    /**
     * Set EstadoRegistro value
     * @param string $estadoRegistro
     * @return \StructType\EstadoFacturaType
     */
    public function setEstadoRegistro($estadoRegistro = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($estadoRegistro) && strlen($estadoRegistro) > 40) || (is_array($estadoRegistro) && count($estadoRegistro) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($estadoRegistro) ? strlen($estadoRegistro) : count($estadoRegistro)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($estadoRegistro) && !is_string($estadoRegistro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estadoRegistro)), __LINE__);
        }
        $this->EstadoRegistro = $estadoRegistro;
        return $this;
    }
    /**
     * Get CodigoErrorRegistro value
     * @return int|null
     */
    public function getCodigoErrorRegistro()
    {
        return $this->CodigoErrorRegistro;
    }
    /**
     * Set CodigoErrorRegistro value
     * @param int $codigoErrorRegistro
     * @return \StructType\EstadoFacturaType
     */
    public function setCodigoErrorRegistro($codigoErrorRegistro = null)
    {
        // validation for constraint: int
        if (!is_null($codigoErrorRegistro) && !is_numeric($codigoErrorRegistro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoErrorRegistro)), __LINE__);
        }
        $this->CodigoErrorRegistro = $codigoErrorRegistro;
        return $this;
    }
    /**
     * Get DescripcionErrorRegistro value
     * @return string|null
     */
    public function getDescripcionErrorRegistro()
    {
        return $this->DescripcionErrorRegistro;
    }
    /**
     * Set DescripcionErrorRegistro value
     * @param string $descripcionErrorRegistro
     * @return \StructType\EstadoFacturaType
     */
    public function setDescripcionErrorRegistro($descripcionErrorRegistro = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descripcionErrorRegistro) && strlen($descripcionErrorRegistro) > 500) || (is_array($descripcionErrorRegistro) && count($descripcionErrorRegistro) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($descripcionErrorRegistro) ? strlen($descripcionErrorRegistro) : count($descripcionErrorRegistro)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descripcionErrorRegistro) && !is_string($descripcionErrorRegistro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descripcionErrorRegistro)), __LINE__);
        }
        $this->DescripcionErrorRegistro = $descripcionErrorRegistro;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstadoFacturaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
