<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetalleIVARecibidaType StructType
 * @subpackage Structs
 */
class DetalleIVARecibidaType extends AbstractStructBase
{
    /**
     * The TipoImpositivo
     * Meta informations extracted from the WSDL
     * - pattern: \d{1,3}(\.\d{0,2})?
     * @var string
     */
    public $TipoImpositivo;
    /**
     * The BaseImponible
     * Meta informations extracted from the WSDL
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $BaseImponible;
    /**
     * The CuotaSoportada
     * Meta informations extracted from the WSDL
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $CuotaSoportada;
    /**
     * The TipoRecargoEquivalencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: \d{1,3}(\.\d{0,2})?
     * @var string
     */
    public $TipoRecargoEquivalencia;
    /**
     * The CuotaRecargoEquivalencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $CuotaRecargoEquivalencia;
    /**
     * The PorcentCompensacionREAGYP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: \d{1,3}(\.\d{0,2})?
     * @var string
     */
    public $PorcentCompensacionREAGYP;
    /**
     * The ImporteCompensacionREAGYP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $ImporteCompensacionREAGYP;
    /**
     * Constructor method for DetalleIVARecibidaType
     * @uses DetalleIVARecibidaType::setTipoImpositivo()
     * @uses DetalleIVARecibidaType::setBaseImponible()
     * @uses DetalleIVARecibidaType::setCuotaSoportada()
     * @uses DetalleIVARecibidaType::setTipoRecargoEquivalencia()
     * @uses DetalleIVARecibidaType::setCuotaRecargoEquivalencia()
     * @uses DetalleIVARecibidaType::setPorcentCompensacionREAGYP()
     * @uses DetalleIVARecibidaType::setImporteCompensacionREAGYP()
     * @param string $tipoImpositivo
     * @param string $baseImponible
     * @param string $cuotaSoportada
     * @param string $tipoRecargoEquivalencia
     * @param string $cuotaRecargoEquivalencia
     * @param string $porcentCompensacionREAGYP
     * @param string $importeCompensacionREAGYP
     */
    public function __construct($tipoImpositivo = null, $baseImponible = null, $cuotaSoportada = null, $tipoRecargoEquivalencia = null, $cuotaRecargoEquivalencia = null, $porcentCompensacionREAGYP = null, $importeCompensacionREAGYP = null)
    {
        $this
            ->setTipoImpositivo($tipoImpositivo)
            ->setBaseImponible($baseImponible)
            ->setCuotaSoportada($cuotaSoportada)
            ->setTipoRecargoEquivalencia($tipoRecargoEquivalencia)
            ->setCuotaRecargoEquivalencia($cuotaRecargoEquivalencia)
            ->setPorcentCompensacionREAGYP($porcentCompensacionREAGYP)
            ->setImporteCompensacionREAGYP($importeCompensacionREAGYP);
    }
    /**
     * Get TipoImpositivo value
     * @return string|null
     */
    public function getTipoImpositivo()
    {
        return $this->TipoImpositivo;
    }
    /**
     * Set TipoImpositivo value
     * @param string $tipoImpositivo
     * @return \StructType\DetalleIVARecibidaType
     */
    public function setTipoImpositivo($tipoImpositivo = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tipoImpositivo) && !preg_match('/\d{1,3}(\.\d{0,2})?/', $tipoImpositivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{1,3}(\.\d{0,2})?", "%s" given', var_export($tipoImpositivo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tipoImpositivo) && !is_string($tipoImpositivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoImpositivo)), __LINE__);
        }
        $this->TipoImpositivo = $tipoImpositivo;
        return $this;
    }
    /**
     * Get BaseImponible value
     * @return string|null
     */
    public function getBaseImponible()
    {
        return $this->BaseImponible;
    }
    /**
     * Set BaseImponible value
     * @param string $baseImponible
     * @return \StructType\DetalleIVARecibidaType
     */
    public function setBaseImponible($baseImponible = null)
    {
        // validation for constraint: pattern
        if (is_scalar($baseImponible) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $baseImponible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($baseImponible, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($baseImponible) && !is_string($baseImponible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseImponible)), __LINE__);
        }
        $this->BaseImponible = $baseImponible;
        return $this;
    }
    /**
     * Get CuotaSoportada value
     * @return string|null
     */
    public function getCuotaSoportada()
    {
        return $this->CuotaSoportada;
    }
    /**
     * Set CuotaSoportada value
     * @param string $cuotaSoportada
     * @return \StructType\DetalleIVARecibidaType
     */
    public function setCuotaSoportada($cuotaSoportada = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cuotaSoportada) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $cuotaSoportada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($cuotaSoportada, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cuotaSoportada) && !is_string($cuotaSoportada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cuotaSoportada)), __LINE__);
        }
        $this->CuotaSoportada = $cuotaSoportada;
        return $this;
    }
    /**
     * Get TipoRecargoEquivalencia value
     * @return string|null
     */
    public function getTipoRecargoEquivalencia()
    {
        return $this->TipoRecargoEquivalencia;
    }
    /**
     * Set TipoRecargoEquivalencia value
     * @param string $tipoRecargoEquivalencia
     * @return \StructType\DetalleIVARecibidaType
     */
    public function setTipoRecargoEquivalencia($tipoRecargoEquivalencia = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tipoRecargoEquivalencia) && !preg_match('/\d{1,3}(\.\d{0,2})?/', $tipoRecargoEquivalencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{1,3}(\.\d{0,2})?", "%s" given', var_export($tipoRecargoEquivalencia, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tipoRecargoEquivalencia) && !is_string($tipoRecargoEquivalencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoRecargoEquivalencia)), __LINE__);
        }
        $this->TipoRecargoEquivalencia = $tipoRecargoEquivalencia;
        return $this;
    }
    /**
     * Get CuotaRecargoEquivalencia value
     * @return string|null
     */
    public function getCuotaRecargoEquivalencia()
    {
        return $this->CuotaRecargoEquivalencia;
    }
    /**
     * Set CuotaRecargoEquivalencia value
     * @param string $cuotaRecargoEquivalencia
     * @return \StructType\DetalleIVARecibidaType
     */
    public function setCuotaRecargoEquivalencia($cuotaRecargoEquivalencia = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cuotaRecargoEquivalencia) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $cuotaRecargoEquivalencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($cuotaRecargoEquivalencia, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cuotaRecargoEquivalencia) && !is_string($cuotaRecargoEquivalencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cuotaRecargoEquivalencia)), __LINE__);
        }
        $this->CuotaRecargoEquivalencia = $cuotaRecargoEquivalencia;
        return $this;
    }
    /**
     * Get PorcentCompensacionREAGYP value
     * @return string|null
     */
    public function getPorcentCompensacionREAGYP()
    {
        return $this->PorcentCompensacionREAGYP;
    }
    /**
     * Set PorcentCompensacionREAGYP value
     * @param string $porcentCompensacionREAGYP
     * @return \StructType\DetalleIVARecibidaType
     */
    public function setPorcentCompensacionREAGYP($porcentCompensacionREAGYP = null)
    {
        // validation for constraint: pattern
        if (is_scalar($porcentCompensacionREAGYP) && !preg_match('/\d{1,3}(\.\d{0,2})?/', $porcentCompensacionREAGYP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{1,3}(\.\d{0,2})?", "%s" given', var_export($porcentCompensacionREAGYP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($porcentCompensacionREAGYP) && !is_string($porcentCompensacionREAGYP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($porcentCompensacionREAGYP)), __LINE__);
        }
        $this->PorcentCompensacionREAGYP = $porcentCompensacionREAGYP;
        return $this;
    }
    /**
     * Get ImporteCompensacionREAGYP value
     * @return string|null
     */
    public function getImporteCompensacionREAGYP()
    {
        return $this->ImporteCompensacionREAGYP;
    }
    /**
     * Set ImporteCompensacionREAGYP value
     * @param string $importeCompensacionREAGYP
     * @return \StructType\DetalleIVARecibidaType
     */
    public function setImporteCompensacionREAGYP($importeCompensacionREAGYP = null)
    {
        // validation for constraint: pattern
        if (is_scalar($importeCompensacionREAGYP) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $importeCompensacionREAGYP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($importeCompensacionREAGYP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($importeCompensacionREAGYP) && !is_string($importeCompensacionREAGYP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importeCompensacionREAGYP)), __LINE__);
        }
        $this->ImporteCompensacionREAGYP = $importeCompensacionREAGYP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DetalleIVARecibidaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
