<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetalleIVAEmitidaPrestacionType StructType
 * @subpackage Structs
 */
class DetalleIVAEmitidaPrestacionType extends AbstractStructBase
{
    /**
     * The TipoImpositivo
     * Meta informations extracted from the WSDL
     * - pattern: \d{1,3}(\.\d{0,2})?
     * @var string
     */
    public $TipoImpositivo;
    /**
     * The BaseImponible
     * Meta informations extracted from the WSDL
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $BaseImponible;
    /**
     * The CuotaRepercutida
     * Meta informations extracted from the WSDL
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $CuotaRepercutida;
    /**
     * Constructor method for DetalleIVAEmitidaPrestacionType
     * @uses DetalleIVAEmitidaPrestacionType::setTipoImpositivo()
     * @uses DetalleIVAEmitidaPrestacionType::setBaseImponible()
     * @uses DetalleIVAEmitidaPrestacionType::setCuotaRepercutida()
     * @param string $tipoImpositivo
     * @param string $baseImponible
     * @param string $cuotaRepercutida
     */
    public function __construct($tipoImpositivo = null, $baseImponible = null, $cuotaRepercutida = null)
    {
        $this
            ->setTipoImpositivo($tipoImpositivo)
            ->setBaseImponible($baseImponible)
            ->setCuotaRepercutida($cuotaRepercutida);
    }
    /**
     * Get TipoImpositivo value
     * @return string|null
     */
    public function getTipoImpositivo()
    {
        return $this->TipoImpositivo;
    }
    /**
     * Set TipoImpositivo value
     * @param string $tipoImpositivo
     * @return \StructType\DetalleIVAEmitidaPrestacionType
     */
    public function setTipoImpositivo($tipoImpositivo = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tipoImpositivo) && !preg_match('/\d{1,3}(\.\d{0,2})?/', $tipoImpositivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{1,3}(\.\d{0,2})?", "%s" given', var_export($tipoImpositivo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tipoImpositivo) && !is_string($tipoImpositivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoImpositivo)), __LINE__);
        }
        $this->TipoImpositivo = $tipoImpositivo;
        return $this;
    }
    /**
     * Get BaseImponible value
     * @return string|null
     */
    public function getBaseImponible()
    {
        return $this->BaseImponible;
    }
    /**
     * Set BaseImponible value
     * @param string $baseImponible
     * @return \StructType\DetalleIVAEmitidaPrestacionType
     */
    public function setBaseImponible($baseImponible = null)
    {
        // validation for constraint: pattern
        if (is_scalar($baseImponible) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $baseImponible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($baseImponible, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($baseImponible) && !is_string($baseImponible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseImponible)), __LINE__);
        }
        $this->BaseImponible = $baseImponible;
        return $this;
    }
    /**
     * Get CuotaRepercutida value
     * @return string|null
     */
    public function getCuotaRepercutida()
    {
        return $this->CuotaRepercutida;
    }
    /**
     * Set CuotaRepercutida value
     * @param string $cuotaRepercutida
     * @return \StructType\DetalleIVAEmitidaPrestacionType
     */
    public function setCuotaRepercutida($cuotaRepercutida = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cuotaRepercutida) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $cuotaRepercutida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($cuotaRepercutida, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cuotaRepercutida) && !is_string($cuotaRepercutida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cuotaRepercutida)), __LINE__);
        }
        $this->CuotaRepercutida = $cuotaRepercutida;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DetalleIVAEmitidaPrestacionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
