<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatosPagoCobroType StructType
 * @subpackage Structs
 */
class DatosPagoCobroType extends AbstractStructBase
{
    /**
     * The Fecha
     * Meta informations extracted from the WSDL
     * - length: 10
     * - pattern: \d{2,2}-\d{2,2}-\d{4,4}
     * @var string
     */
    public $Fecha;
    /**
     * The Importe
     * Meta informations extracted from the WSDL
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $Importe;
    /**
     * The Medio
     * @var string
     */
    public $Medio;
    /**
     * The Cuenta_O_Medio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 34
     * @var string
     */
    public $Cuenta_O_Medio;
    /**
     * Constructor method for DatosPagoCobroType
     * @uses DatosPagoCobroType::setFecha()
     * @uses DatosPagoCobroType::setImporte()
     * @uses DatosPagoCobroType::setMedio()
     * @uses DatosPagoCobroType::setCuenta_O_Medio()
     * @param string $fecha
     * @param string $importe
     * @param string $medio
     * @param string $cuenta_O_Medio
     */
    public function __construct($fecha = null, $importe = null, $medio = null, $cuenta_O_Medio = null)
    {
        $this
            ->setFecha($fecha)
            ->setImporte($importe)
            ->setMedio($medio)
            ->setCuenta_O_Medio($cuenta_O_Medio);
    }
    /**
     * Get Fecha value
     * @return string|null
     */
    public function getFecha()
    {
        return $this->Fecha;
    }
    /**
     * Set Fecha value
     * @param string $fecha
     * @return \StructType\DatosPagoCobroType
     */
    public function setFecha($fecha = null)
    {
        // validation for constraint: length
        if ((is_scalar($fecha) && strlen($fecha) !== 10) || (is_array($fecha) && count($fecha) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($fecha) && !preg_match('/\d{2,2}-\d{2,2}-\d{4,4}/', $fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{2,2}-\d{2,2}-\d{4,4}", "%s" given', var_export($fecha, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fecha) && !is_string($fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fecha)), __LINE__);
        }
        $this->Fecha = $fecha;
        return $this;
    }
    /**
     * Get Importe value
     * @return string|null
     */
    public function getImporte()
    {
        return $this->Importe;
    }
    /**
     * Set Importe value
     * @param string $importe
     * @return \StructType\DatosPagoCobroType
     */
    public function setImporte($importe = null)
    {
        // validation for constraint: pattern
        if (is_scalar($importe) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $importe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($importe, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($importe) && !is_string($importe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importe)), __LINE__);
        }
        $this->Importe = $importe;
        return $this;
    }
    /**
     * Get Medio value
     * @return string|null
     */
    public function getMedio()
    {
        return $this->Medio;
    }
    /**
     * Set Medio value
     * @uses \EnumType\MedioPagoType::valueIsValid()
     * @uses \EnumType\MedioPagoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $medio
     * @return \StructType\DatosPagoCobroType
     */
    public function setMedio($medio = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MedioPagoType::valueIsValid($medio)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $medio, implode(', ', \EnumType\MedioPagoType::getValidValues())), __LINE__);
        }
        $this->Medio = $medio;
        return $this;
    }
    /**
     * Get Cuenta_O_Medio value
     * @return string|null
     */
    public function getCuenta_O_Medio()
    {
        return $this->Cuenta_O_Medio;
    }
    /**
     * Set Cuenta_O_Medio value
     * @param string $cuenta_O_Medio
     * @return \StructType\DatosPagoCobroType
     */
    public function setCuenta_O_Medio($cuenta_O_Medio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cuenta_O_Medio) && strlen($cuenta_O_Medio) > 34) || (is_array($cuenta_O_Medio) && count($cuenta_O_Medio) > 34)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 34 element(s) or a scalar of 34 character(s) at most, "%d" length given', is_scalar($cuenta_O_Medio) ? strlen($cuenta_O_Medio) : count($cuenta_O_Medio)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cuenta_O_Medio) && !is_string($cuenta_O_Medio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cuenta_O_Medio)), __LINE__);
        }
        $this->Cuenta_O_Medio = $cuenta_O_Medio;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatosPagoCobroType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
