<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabeceraSiiBaja StructType
 * Meta informations extracted from the WSDL
 * - documentation: Datos de contexto de un suministro sin especificar el timpo de comunicacion
 * @subpackage Structs
 */
class CabeceraSiiBaja extends AbstractStructBase
{
    /**
     * The IDVersionSii
     * @var string
     */
    public $IDVersionSii;
    /**
     * The Titular
     * Meta informations extracted from the WSDL
     * - documentation: Titular de los libros de registro que suministra la información
     * @var \StructType\PersonaFisicaJuridicaESType
     */
    public $Titular;
    /**
     * Constructor method for CabeceraSiiBaja
     * @uses CabeceraSiiBaja::setIDVersionSii()
     * @uses CabeceraSiiBaja::setTitular()
     * @param string $iDVersionSii
     * @param \StructType\PersonaFisicaJuridicaESType $titular
     */
    public function __construct($iDVersionSii = null, \StructType\PersonaFisicaJuridicaESType $titular = null)
    {
        $this
            ->setIDVersionSii($iDVersionSii)
            ->setTitular($titular);
    }
    /**
     * Get IDVersionSii value
     * @return string|null
     */
    public function getIDVersionSii()
    {
        return $this->IDVersionSii;
    }
    /**
     * Set IDVersionSii value
     * @uses \EnumType\VersionSiiType::valueIsValid()
     * @uses \EnumType\VersionSiiType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDVersionSii
     * @return \StructType\CabeceraSiiBaja
     */
    public function setIDVersionSii($iDVersionSii = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VersionSiiType::valueIsValid($iDVersionSii)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iDVersionSii, implode(', ', \EnumType\VersionSiiType::getValidValues())), __LINE__);
        }
        $this->IDVersionSii = $iDVersionSii;
        return $this;
    }
    /**
     * Get Titular value
     * @return \StructType\PersonaFisicaJuridicaESType|null
     */
    public function getTitular()
    {
        return $this->Titular;
    }
    /**
     * Set Titular value
     * @param \StructType\PersonaFisicaJuridicaESType $titular
     * @return \StructType\CabeceraSiiBaja
     */
    public function setTitular(\StructType\PersonaFisicaJuridicaESType $titular = null)
    {
        $this->Titular = $titular;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabeceraSiiBaja
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
