<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BienDeInversionType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Apunte correspondiente al libro de bienes de inversion.
 * @subpackage Structs
 */
class BienDeInversionType extends AbstractStructBase
{
    /**
     * The IdentificacionBien
     * Meta informations extracted from the WSDL
     * - maxLength: 40
     * @var string
     */
    public $IdentificacionBien;
    /**
     * The FechaInicioUtilizacion
     * Meta informations extracted from the WSDL
     * - length: 10
     * - pattern: \d{2,2}-\d{2,2}-\d{4,4}
     * @var string
     */
    public $FechaInicioUtilizacion;
    /**
     * The ProrrataAnualDefinitiva
     * Meta informations extracted from the WSDL
     * - pattern: \d{1,3}(\.\d{0,2})?
     * @var string
     */
    public $ProrrataAnualDefinitiva;
    /**
     * The RegularizacionAnualDeduccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $RegularizacionAnualDeduccion;
    /**
     * The IdentificacionEntrega
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 40
     * @var string
     */
    public $IdentificacionEntrega;
    /**
     * The RegularizacionDeduccionEfectuada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $RegularizacionDeduccionEfectuada;
    /**
     * Constructor method for BienDeInversionType
     * @uses BienDeInversionType::setIdentificacionBien()
     * @uses BienDeInversionType::setFechaInicioUtilizacion()
     * @uses BienDeInversionType::setProrrataAnualDefinitiva()
     * @uses BienDeInversionType::setRegularizacionAnualDeduccion()
     * @uses BienDeInversionType::setIdentificacionEntrega()
     * @uses BienDeInversionType::setRegularizacionDeduccionEfectuada()
     * @param string $identificacionBien
     * @param string $fechaInicioUtilizacion
     * @param string $prorrataAnualDefinitiva
     * @param string $regularizacionAnualDeduccion
     * @param string $identificacionEntrega
     * @param string $regularizacionDeduccionEfectuada
     */
    public function __construct($identificacionBien = null, $fechaInicioUtilizacion = null, $prorrataAnualDefinitiva = null, $regularizacionAnualDeduccion = null, $identificacionEntrega = null, $regularizacionDeduccionEfectuada = null)
    {
        $this
            ->setIdentificacionBien($identificacionBien)
            ->setFechaInicioUtilizacion($fechaInicioUtilizacion)
            ->setProrrataAnualDefinitiva($prorrataAnualDefinitiva)
            ->setRegularizacionAnualDeduccion($regularizacionAnualDeduccion)
            ->setIdentificacionEntrega($identificacionEntrega)
            ->setRegularizacionDeduccionEfectuada($regularizacionDeduccionEfectuada);
    }
    /**
     * Get IdentificacionBien value
     * @return string|null
     */
    public function getIdentificacionBien()
    {
        return $this->IdentificacionBien;
    }
    /**
     * Set IdentificacionBien value
     * @param string $identificacionBien
     * @return \StructType\BienDeInversionType
     */
    public function setIdentificacionBien($identificacionBien = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificacionBien) && strlen($identificacionBien) > 40) || (is_array($identificacionBien) && count($identificacionBien) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($identificacionBien) ? strlen($identificacionBien) : count($identificacionBien)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificacionBien) && !is_string($identificacionBien)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificacionBien)), __LINE__);
        }
        $this->IdentificacionBien = $identificacionBien;
        return $this;
    }
    /**
     * Get FechaInicioUtilizacion value
     * @return string|null
     */
    public function getFechaInicioUtilizacion()
    {
        return $this->FechaInicioUtilizacion;
    }
    /**
     * Set FechaInicioUtilizacion value
     * @param string $fechaInicioUtilizacion
     * @return \StructType\BienDeInversionType
     */
    public function setFechaInicioUtilizacion($fechaInicioUtilizacion = null)
    {
        // validation for constraint: length
        if ((is_scalar($fechaInicioUtilizacion) && strlen($fechaInicioUtilizacion) !== 10) || (is_array($fechaInicioUtilizacion) && count($fechaInicioUtilizacion) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($fechaInicioUtilizacion) && !preg_match('/\d{2,2}-\d{2,2}-\d{4,4}/', $fechaInicioUtilizacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{2,2}-\d{2,2}-\d{4,4}", "%s" given', var_export($fechaInicioUtilizacion, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fechaInicioUtilizacion) && !is_string($fechaInicioUtilizacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaInicioUtilizacion)), __LINE__);
        }
        $this->FechaInicioUtilizacion = $fechaInicioUtilizacion;
        return $this;
    }
    /**
     * Get ProrrataAnualDefinitiva value
     * @return string|null
     */
    public function getProrrataAnualDefinitiva()
    {
        return $this->ProrrataAnualDefinitiva;
    }
    /**
     * Set ProrrataAnualDefinitiva value
     * @param string $prorrataAnualDefinitiva
     * @return \StructType\BienDeInversionType
     */
    public function setProrrataAnualDefinitiva($prorrataAnualDefinitiva = null)
    {
        // validation for constraint: pattern
        if (is_scalar($prorrataAnualDefinitiva) && !preg_match('/\d{1,3}(\.\d{0,2})?/', $prorrataAnualDefinitiva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{1,3}(\.\d{0,2})?", "%s" given', var_export($prorrataAnualDefinitiva, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prorrataAnualDefinitiva) && !is_string($prorrataAnualDefinitiva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prorrataAnualDefinitiva)), __LINE__);
        }
        $this->ProrrataAnualDefinitiva = $prorrataAnualDefinitiva;
        return $this;
    }
    /**
     * Get RegularizacionAnualDeduccion value
     * @return string|null
     */
    public function getRegularizacionAnualDeduccion()
    {
        return $this->RegularizacionAnualDeduccion;
    }
    /**
     * Set RegularizacionAnualDeduccion value
     * @param string $regularizacionAnualDeduccion
     * @return \StructType\BienDeInversionType
     */
    public function setRegularizacionAnualDeduccion($regularizacionAnualDeduccion = null)
    {
        // validation for constraint: pattern
        if (is_scalar($regularizacionAnualDeduccion) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $regularizacionAnualDeduccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($regularizacionAnualDeduccion, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regularizacionAnualDeduccion) && !is_string($regularizacionAnualDeduccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regularizacionAnualDeduccion)), __LINE__);
        }
        $this->RegularizacionAnualDeduccion = $regularizacionAnualDeduccion;
        return $this;
    }
    /**
     * Get IdentificacionEntrega value
     * @return string|null
     */
    public function getIdentificacionEntrega()
    {
        return $this->IdentificacionEntrega;
    }
    /**
     * Set IdentificacionEntrega value
     * @param string $identificacionEntrega
     * @return \StructType\BienDeInversionType
     */
    public function setIdentificacionEntrega($identificacionEntrega = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificacionEntrega) && strlen($identificacionEntrega) > 40) || (is_array($identificacionEntrega) && count($identificacionEntrega) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($identificacionEntrega) ? strlen($identificacionEntrega) : count($identificacionEntrega)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificacionEntrega) && !is_string($identificacionEntrega)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificacionEntrega)), __LINE__);
        }
        $this->IdentificacionEntrega = $identificacionEntrega;
        return $this;
    }
    /**
     * Get RegularizacionDeduccionEfectuada value
     * @return string|null
     */
    public function getRegularizacionDeduccionEfectuada()
    {
        return $this->RegularizacionDeduccionEfectuada;
    }
    /**
     * Set RegularizacionDeduccionEfectuada value
     * @param string $regularizacionDeduccionEfectuada
     * @return \StructType\BienDeInversionType
     */
    public function setRegularizacionDeduccionEfectuada($regularizacionDeduccionEfectuada = null)
    {
        // validation for constraint: pattern
        if (is_scalar($regularizacionDeduccionEfectuada) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $regularizacionDeduccionEfectuada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($regularizacionDeduccionEfectuada, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regularizacionDeduccionEfectuada) && !is_string($regularizacionDeduccionEfectuada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regularizacionDeduccionEfectuada)), __LINE__);
        }
        $this->RegularizacionDeduccionEfectuada = $regularizacionDeduccionEfectuada;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BienDeInversionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
