<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AduanasType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Desglose cuando corresponda de la información asociada a los documentos de aduanas
 * @subpackage Structs
 */
class AduanasType extends AbstractStructBase
{
    /**
     * The NumeroDUA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 40
     * @var string
     */
    public $NumeroDUA;
    /**
     * The FechaRegContableDUA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 10
     * - pattern: \d{2,2}-\d{2,2}-\d{4,4}
     * @var string
     */
    public $FechaRegContableDUA;
    /**
     * Constructor method for AduanasType
     * @uses AduanasType::setNumeroDUA()
     * @uses AduanasType::setFechaRegContableDUA()
     * @param string $numeroDUA
     * @param string $fechaRegContableDUA
     */
    public function __construct($numeroDUA = null, $fechaRegContableDUA = null)
    {
        $this
            ->setNumeroDUA($numeroDUA)
            ->setFechaRegContableDUA($fechaRegContableDUA);
    }
    /**
     * Get NumeroDUA value
     * @return string|null
     */
    public function getNumeroDUA()
    {
        return $this->NumeroDUA;
    }
    /**
     * Set NumeroDUA value
     * @param string $numeroDUA
     * @return \StructType\AduanasType
     */
    public function setNumeroDUA($numeroDUA = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numeroDUA) && strlen($numeroDUA) > 40) || (is_array($numeroDUA) && count($numeroDUA) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($numeroDUA) ? strlen($numeroDUA) : count($numeroDUA)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numeroDUA) && !is_string($numeroDUA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroDUA)), __LINE__);
        }
        $this->NumeroDUA = $numeroDUA;
        return $this;
    }
    /**
     * Get FechaRegContableDUA value
     * @return string|null
     */
    public function getFechaRegContableDUA()
    {
        return $this->FechaRegContableDUA;
    }
    /**
     * Set FechaRegContableDUA value
     * @param string $fechaRegContableDUA
     * @return \StructType\AduanasType
     */
    public function setFechaRegContableDUA($fechaRegContableDUA = null)
    {
        // validation for constraint: length
        if ((is_scalar($fechaRegContableDUA) && strlen($fechaRegContableDUA) !== 10) || (is_array($fechaRegContableDUA) && count($fechaRegContableDUA) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($fechaRegContableDUA) && !preg_match('/\d{2,2}-\d{2,2}-\d{4,4}/', $fechaRegContableDUA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{2,2}-\d{2,2}-\d{4,4}", "%s" given', var_export($fechaRegContableDUA, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fechaRegContableDUA) && !is_string($fechaRegContableDUA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaRegContableDUA)), __LINE__);
        }
        $this->FechaRegContableDUA = $fechaRegContableDUA;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AduanasType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
