<?php

namespace EnumType;

/**
 * This class stands for TipoOperacionSujetaNoExentaType EnumType
 * @subpackage Enumerations
 */
class TipoOperacionSujetaNoExentaType
{
    /**
     * Constant for value 'S1'
     * @return string 'S1'
     */
    const VALUE_S_1 = 'S1';
    /**
     * Constant for value 'S2'
     * @return string 'S2'
     */
    const VALUE_S_2 = 'S2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_S_1
     * @uses self::VALUE_S_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_S_1,
            self::VALUE_S_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
