<?php

namespace EnumType;

/**
 * This class stands for MedioPagoType EnumType
 * @subpackage Enumerations
 */
class MedioPagoType
{
    /**
     * Constant for value '01'
     * @return string '01'
     */
    const VALUE_01 = '01';
    /**
     * Constant for value '02'
     * @return string '02'
     */
    const VALUE_02 = '02';
    /**
     * Constant for value '03'
     * @return string '03'
     */
    const VALUE_03 = '03';
    /**
     * Constant for value '04'
     * @return string '04'
     */
    const VALUE_04 = '04';
    /**
     * Constant for value '05'
     * @return string '05'
     */
    const VALUE_05 = '05';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_01
     * @uses self::VALUE_02
     * @uses self::VALUE_03
     * @uses self::VALUE_04
     * @uses self::VALUE_05
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_01,
            self::VALUE_02,
            self::VALUE_03,
            self::VALUE_04,
            self::VALUE_05,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
