<?php

namespace EnumType;

/**
 * This class stands for EstadoEnvioType EnumType
 * @subpackage Enumerations
 */
class EstadoEnvioType
{
    /**
     * Constant for value 'Correcto'
     * @return string 'Correcto'
     */
    const VALUE_CORRECTO = 'Correcto';
    /**
     * Constant for value 'ParcialmenteCorrecto'
     * @return string 'ParcialmenteCorrecto'
     */
    const VALUE_PARCIALMENTE_CORRECTO = 'ParcialmenteCorrecto';
    /**
     * Constant for value 'Incorrecto'
     * @return string 'Incorrecto'
     */
    const VALUE_INCORRECTO = 'Incorrecto';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CORRECTO
     * @uses self::VALUE_PARCIALMENTE_CORRECTO
     * @uses self::VALUE_INCORRECTO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CORRECTO,
            self::VALUE_PARCIALMENTE_CORRECTO,
            self::VALUE_INCORRECTO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
