<?php

namespace EnumType;

/**
 * This class stands for CountryMiembroType EnumType
 * @subpackage Enumerations
 */
class CountryMiembroType
{
    /**
     * Constant for value 'DE'
     * @return string 'DE'
     */
    const VALUE_DE = 'DE';
    /**
     * Constant for value 'AT'
     * @return string 'AT'
     */
    const VALUE_AT = 'AT';
    /**
     * Constant for value 'BE'
     * @return string 'BE'
     */
    const VALUE_BE = 'BE';
    /**
     * Constant for value 'BG'
     * @return string 'BG'
     */
    const VALUE_BG = 'BG';
    /**
     * Constant for value 'CZ'
     * @return string 'CZ'
     */
    const VALUE_CZ = 'CZ';
    /**
     * Constant for value 'CY'
     * @return string 'CY'
     */
    const VALUE_CY = 'CY';
    /**
     * Constant for value 'HR'
     * @return string 'HR'
     */
    const VALUE_HR = 'HR';
    /**
     * Constant for value 'DK'
     * @return string 'DK'
     */
    const VALUE_DK = 'DK';
    /**
     * Constant for value 'SK'
     * @return string 'SK'
     */
    const VALUE_SK = 'SK';
    /**
     * Constant for value 'SI'
     * @return string 'SI'
     */
    const VALUE_SI = 'SI';
    /**
     * Constant for value 'ES'
     * @return string 'ES'
     */
    const VALUE_ES = 'ES';
    /**
     * Constant for value 'EE'
     * @return string 'EE'
     */
    const VALUE_EE = 'EE';
    /**
     * Constant for value 'FI'
     * @return string 'FI'
     */
    const VALUE_FI = 'FI';
    /**
     * Constant for value 'FR'
     * @return string 'FR'
     */
    const VALUE_FR = 'FR';
    /**
     * Constant for value 'GR'
     * @return string 'GR'
     */
    const VALUE_GR = 'GR';
    /**
     * Constant for value 'HU'
     * @return string 'HU'
     */
    const VALUE_HU = 'HU';
    /**
     * Constant for value 'IE'
     * @return string 'IE'
     */
    const VALUE_IE = 'IE';
    /**
     * Constant for value 'IT'
     * @return string 'IT'
     */
    const VALUE_IT = 'IT';
    /**
     * Constant for value 'LV'
     * @return string 'LV'
     */
    const VALUE_LV = 'LV';
    /**
     * Constant for value 'LT'
     * @return string 'LT'
     */
    const VALUE_LT = 'LT';
    /**
     * Constant for value 'LU'
     * @return string 'LU'
     */
    const VALUE_LU = 'LU';
    /**
     * Constant for value 'MT'
     * @return string 'MT'
     */
    const VALUE_MT = 'MT';
    /**
     * Constant for value 'NL'
     * @return string 'NL'
     */
    const VALUE_NL = 'NL';
    /**
     * Constant for value 'PL'
     * @return string 'PL'
     */
    const VALUE_PL = 'PL';
    /**
     * Constant for value 'PT'
     * @return string 'PT'
     */
    const VALUE_PT = 'PT';
    /**
     * Constant for value 'GB'
     * @return string 'GB'
     */
    const VALUE_GB = 'GB';
    /**
     * Constant for value 'RO'
     * @return string 'RO'
     */
    const VALUE_RO = 'RO';
    /**
     * Constant for value 'SE'
     * @return string 'SE'
     */
    const VALUE_SE = 'SE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DE
     * @uses self::VALUE_AT
     * @uses self::VALUE_BE
     * @uses self::VALUE_BG
     * @uses self::VALUE_CZ
     * @uses self::VALUE_CY
     * @uses self::VALUE_HR
     * @uses self::VALUE_DK
     * @uses self::VALUE_SK
     * @uses self::VALUE_SI
     * @uses self::VALUE_ES
     * @uses self::VALUE_EE
     * @uses self::VALUE_FI
     * @uses self::VALUE_FR
     * @uses self::VALUE_GR
     * @uses self::VALUE_HU
     * @uses self::VALUE_IE
     * @uses self::VALUE_IT
     * @uses self::VALUE_LV
     * @uses self::VALUE_LT
     * @uses self::VALUE_LU
     * @uses self::VALUE_MT
     * @uses self::VALUE_NL
     * @uses self::VALUE_PL
     * @uses self::VALUE_PT
     * @uses self::VALUE_GB
     * @uses self::VALUE_RO
     * @uses self::VALUE_SE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DE,
            self::VALUE_AT,
            self::VALUE_BE,
            self::VALUE_BG,
            self::VALUE_CZ,
            self::VALUE_CY,
            self::VALUE_HR,
            self::VALUE_DK,
            self::VALUE_SK,
            self::VALUE_SI,
            self::VALUE_ES,
            self::VALUE_EE,
            self::VALUE_FI,
            self::VALUE_FR,
            self::VALUE_GR,
            self::VALUE_HU,
            self::VALUE_IE,
            self::VALUE_IT,
            self::VALUE_LV,
            self::VALUE_LT,
            self::VALUE_LU,
            self::VALUE_MT,
            self::VALUE_NL,
            self::VALUE_PL,
            self::VALUE_PT,
            self::VALUE_GB,
            self::VALUE_RO,
            self::VALUE_SE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
