<?php

namespace EnumType;

/**
 * This class stands for ClaveTipoFacturaType EnumType
 * @subpackage Enumerations
 */
class ClaveTipoFacturaType
{
    /**
     * Constant for value 'F1'
     * @return string 'F1'
     */
    const VALUE_F_1 = 'F1';
    /**
     * Constant for value 'F2'
     * @return string 'F2'
     */
    const VALUE_F_2 = 'F2';
    /**
     * Constant for value 'R1'
     * @return string 'R1'
     */
    const VALUE_R_1 = 'R1';
    /**
     * Constant for value 'R2'
     * @return string 'R2'
     */
    const VALUE_R_2 = 'R2';
    /**
     * Constant for value 'R3'
     * @return string 'R3'
     */
    const VALUE_R_3 = 'R3';
    /**
     * Constant for value 'R4'
     * @return string 'R4'
     */
    const VALUE_R_4 = 'R4';
    /**
     * Constant for value 'R5'
     * @return string 'R5'
     */
    const VALUE_R_5 = 'R5';
    /**
     * Constant for value 'F3'
     * @return string 'F3'
     */
    const VALUE_F_3 = 'F3';
    /**
     * Constant for value 'F4'
     * @return string 'F4'
     */
    const VALUE_F_4 = 'F4';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_F_1
     * @uses self::VALUE_F_2
     * @uses self::VALUE_R_1
     * @uses self::VALUE_R_2
     * @uses self::VALUE_R_3
     * @uses self::VALUE_R_4
     * @uses self::VALUE_R_5
     * @uses self::VALUE_F_3
     * @uses self::VALUE_F_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_F_1,
            self::VALUE_F_2,
            self::VALUE_R_1,
            self::VALUE_R_2,
            self::VALUE_R_3,
            self::VALUE_R_4,
            self::VALUE_R_5,
            self::VALUE_F_3,
            self::VALUE_F_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
