<?php

namespace EnumType;

/**
 * This class stands for ClaveTipoComunicacionType EnumType
 * @subpackage Enumerations
 */
class ClaveTipoComunicacionType
{
    /**
     * Constant for value 'A0'
     * @return string 'A0'
     */
    const VALUE_A_0 = 'A0';
    /**
     * Constant for value 'A1'
     * @return string 'A1'
     */
    const VALUE_A_1 = 'A1';
    /**
     * Constant for value 'A4'
     * @return string 'A4'
     */
    const VALUE_A_4 = 'A4';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_A_0
     * @uses self::VALUE_A_1
     * @uses self::VALUE_A_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_A_0,
            self::VALUE_A_1,
            self::VALUE_A_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
