<?php

namespace EnumType;

/**
 * This class stands for CausaExencionType EnumType
 * @subpackage Enumerations
 */
class CausaExencionType
{
    /**
     * Constant for value 'E1'
     * @return string 'E1'
     */
    const VALUE_E_1 = 'E1';
    /**
     * Constant for value 'E2'
     * @return string 'E2'
     */
    const VALUE_E_2 = 'E2';
    /**
     * Constant for value 'E3'
     * @return string 'E3'
     */
    const VALUE_E_3 = 'E3';
    /**
     * Constant for value 'E4'
     * @return string 'E4'
     */
    const VALUE_E_4 = 'E4';
    /**
     * Constant for value 'E5'
     * @return string 'E5'
     */
    const VALUE_E_5 = 'E5';
    /**
     * Constant for value 'E6'
     * @return string 'E6'
     */
    const VALUE_E_6 = 'E6';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E_1
     * @uses self::VALUE_E_2
     * @uses self::VALUE_E_3
     * @uses self::VALUE_E_4
     * @uses self::VALUE_E_5
     * @uses self::VALUE_E_6
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E_1,
            self::VALUE_E_2,
            self::VALUE_E_3,
            self::VALUE_E_4,
            self::VALUE_E_5,
            self::VALUE_E_6,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
