<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuministroLRCobrosEmitidas StructType
 * Meta informations extracted from the WSDL
 * - documentation: Suministro de información de Cobros sobre el libro de registro de facturas expedidas
 * @subpackage Structs
 */
class SuministroLRCobrosEmitidas extends SuministroInformacionBaja
{
    /**
     * The RegistroLRCobros
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10000
     * @var \StructType\LRCobrosEmitidasType[]
     */
    public $RegistroLRCobros;
    /**
     * Constructor method for SuministroLRCobrosEmitidas
     * @uses SuministroLRCobrosEmitidas::setRegistroLRCobros()
     * @param \StructType\LRCobrosEmitidasType[] $registroLRCobros
     */
    public function __construct(array $registroLRCobros = array())
    {
        $this
            ->setRegistroLRCobros($registroLRCobros);
    }
    /**
     * Get RegistroLRCobros value
     * @return \StructType\LRCobrosEmitidasType[]|null
     */
    public function getRegistroLRCobros()
    {
        return $this->RegistroLRCobros;
    }
    /**
     * Set RegistroLRCobros value
     * @throws \InvalidArgumentException
     * @param \StructType\LRCobrosEmitidasType[] $registroLRCobros
     * @return \StructType\SuministroLRCobrosEmitidas
     */
    public function setRegistroLRCobros(array $registroLRCobros = array())
    {
        foreach ($registroLRCobros as $suministroLRCobrosEmitidasRegistroLRCobrosItem) {
            // validation for constraint: itemType
            if (!$suministroLRCobrosEmitidasRegistroLRCobrosItem instanceof \StructType\LRCobrosEmitidasType) {
                throw new \InvalidArgumentException(sprintf('The RegistroLRCobros property can only contain items of \StructType\LRCobrosEmitidasType, "%s" given', is_object($suministroLRCobrosEmitidasRegistroLRCobrosItem) ? get_class($suministroLRCobrosEmitidasRegistroLRCobrosItem) : gettype($suministroLRCobrosEmitidasRegistroLRCobrosItem)), __LINE__);
            }
        }
        $this->RegistroLRCobros = $registroLRCobros;
        return $this;
    }
    /**
     * Add item to RegistroLRCobros value
     * @throws \InvalidArgumentException
     * @param \StructType\LRCobrosEmitidasType $item
     * @return \StructType\SuministroLRCobrosEmitidas
     */
    public function addToRegistroLRCobros(\StructType\LRCobrosEmitidasType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LRCobrosEmitidasType) {
            throw new \InvalidArgumentException(sprintf('The RegistroLRCobros property can only contain items of \StructType\LRCobrosEmitidasType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RegistroLRCobros[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SuministroLRCobrosEmitidas
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
