<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaLROComunitariasType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Respuesta a un envío Sii para suministro de Facturas emitidas
 * @subpackage Structs
 */
class RespuestaLROComunitariasType extends RespuestaComunAltaType
{
    /**
     * The RespuestaLinea
     * Meta informations extracted from the WSDL
     * - documentation: Estado detallado de cada línea del suministro.
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var \StructType\RespuestaComunitariaType[]
     */
    public $RespuestaLinea;
    /**
     * Constructor method for RespuestaLROComunitariasType
     * @uses RespuestaLROComunitariasType::setRespuestaLinea()
     * @param \StructType\RespuestaComunitariaType[] $respuestaLinea
     */
    public function __construct(array $respuestaLinea = array())
    {
        $this
            ->setRespuestaLinea($respuestaLinea);
    }
    /**
     * Get RespuestaLinea value
     * @return \StructType\RespuestaComunitariaType[]|null
     */
    public function getRespuestaLinea()
    {
        return $this->RespuestaLinea;
    }
    /**
     * Set RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaComunitariaType[] $respuestaLinea
     * @return \StructType\RespuestaLROComunitariasType
     */
    public function setRespuestaLinea(array $respuestaLinea = array())
    {
        foreach ($respuestaLinea as $respuestaLROComunitariasTypeRespuestaLineaItem) {
            // validation for constraint: itemType
            if (!$respuestaLROComunitariasTypeRespuestaLineaItem instanceof \StructType\RespuestaComunitariaType) {
                throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaComunitariaType, "%s" given', is_object($respuestaLROComunitariasTypeRespuestaLineaItem) ? get_class($respuestaLROComunitariasTypeRespuestaLineaItem) : gettype($respuestaLROComunitariasTypeRespuestaLineaItem)), __LINE__);
            }
        }
        $this->RespuestaLinea = $respuestaLinea;
        return $this;
    }
    /**
     * Add item to RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaComunitariaType $item
     * @return \StructType\RespuestaLROComunitariasType
     */
    public function addToRespuestaLinea(\StructType\RespuestaComunitariaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RespuestaComunitariaType) {
            throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaComunitariaType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RespuestaLinea[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespuestaLROComunitariasType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
