<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaLRFRecibidasType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Respuesta a un envío Sii para suministro de Facturas emitidas
 * @subpackage Structs
 */
class RespuestaLRFRecibidasType extends RespuestaComunAltaType
{
    /**
     * The RespuestaLinea
     * Meta informations extracted from the WSDL
     * - documentation: Estado detallado de cada línea del suministro.
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var \StructType\RespuestaRecibidaType[]
     */
    public $RespuestaLinea;
    /**
     * Constructor method for RespuestaLRFRecibidasType
     * @uses RespuestaLRFRecibidasType::setRespuestaLinea()
     * @param \StructType\RespuestaRecibidaType[] $respuestaLinea
     */
    public function __construct(array $respuestaLinea = array())
    {
        $this
            ->setRespuestaLinea($respuestaLinea);
    }
    /**
     * Get RespuestaLinea value
     * @return \StructType\RespuestaRecibidaType[]|null
     */
    public function getRespuestaLinea()
    {
        return $this->RespuestaLinea;
    }
    /**
     * Set RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaRecibidaType[] $respuestaLinea
     * @return \StructType\RespuestaLRFRecibidasType
     */
    public function setRespuestaLinea(array $respuestaLinea = array())
    {
        foreach ($respuestaLinea as $respuestaLRFRecibidasTypeRespuestaLineaItem) {
            // validation for constraint: itemType
            if (!$respuestaLRFRecibidasTypeRespuestaLineaItem instanceof \StructType\RespuestaRecibidaType) {
                throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaRecibidaType, "%s" given', is_object($respuestaLRFRecibidasTypeRespuestaLineaItem) ? get_class($respuestaLRFRecibidasTypeRespuestaLineaItem) : gettype($respuestaLRFRecibidasTypeRespuestaLineaItem)), __LINE__);
            }
        }
        $this->RespuestaLinea = $respuestaLinea;
        return $this;
    }
    /**
     * Add item to RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaRecibidaType $item
     * @return \StructType\RespuestaLRFRecibidasType
     */
    public function addToRespuestaLinea(\StructType\RespuestaRecibidaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RespuestaRecibidaType) {
            throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaRecibidaType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RespuestaLinea[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespuestaLRFRecibidasType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
