<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaLRBajaIMetalicoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Respuesta a un envío Sii
 * @subpackage Structs
 */
class RespuestaLRBajaIMetalicoType extends RespuestaComunBajaType
{
    /**
     * The RespuestaLinea
     * Meta informations extracted from the WSDL
     * - documentation: Estado detallado de cada línea del suministro.
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var \StructType\RespuestaMetalicoType[]
     */
    public $RespuestaLinea;
    /**
     * Constructor method for RespuestaLRBajaIMetalicoType
     * @uses RespuestaLRBajaIMetalicoType::setRespuestaLinea()
     * @param \StructType\RespuestaMetalicoType[] $respuestaLinea
     */
    public function __construct(array $respuestaLinea = array())
    {
        $this
            ->setRespuestaLinea($respuestaLinea);
    }
    /**
     * Get RespuestaLinea value
     * @return \StructType\RespuestaMetalicoType[]|null
     */
    public function getRespuestaLinea()
    {
        return $this->RespuestaLinea;
    }
    /**
     * Set RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaMetalicoType[] $respuestaLinea
     * @return \StructType\RespuestaLRBajaIMetalicoType
     */
    public function setRespuestaLinea(array $respuestaLinea = array())
    {
        foreach ($respuestaLinea as $respuestaLRBajaIMetalicoTypeRespuestaLineaItem) {
            // validation for constraint: itemType
            if (!$respuestaLRBajaIMetalicoTypeRespuestaLineaItem instanceof \StructType\RespuestaMetalicoType) {
                throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaMetalicoType, "%s" given', is_object($respuestaLRBajaIMetalicoTypeRespuestaLineaItem) ? get_class($respuestaLRBajaIMetalicoTypeRespuestaLineaItem) : gettype($respuestaLRBajaIMetalicoTypeRespuestaLineaItem)), __LINE__);
            }
        }
        $this->RespuestaLinea = $respuestaLinea;
        return $this;
    }
    /**
     * Add item to RespuestaLinea value
     * @throws \InvalidArgumentException
     * @param \StructType\RespuestaMetalicoType $item
     * @return \StructType\RespuestaLRBajaIMetalicoType
     */
    public function addToRespuestaLinea(\StructType\RespuestaMetalicoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RespuestaMetalicoType) {
            throw new \InvalidArgumentException(sprintf('The RespuestaLinea property can only contain items of \StructType\RespuestaMetalicoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RespuestaLinea[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespuestaLRBajaIMetalicoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
