<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaConsultaFacturaCobrosType StructType
 * @subpackage Structs
 */
class RespuestaConsultaFacturaCobrosType extends ConsultaInformacion
{
    /**
     * The IDFactura
     * @var \StructType\IDFacturaExpedidaBCType
     */
    public $IDFactura;
    /**
     * The IndicadorPaginacion
     * @var string
     */
    public $IndicadorPaginacion;
    /**
     * The ResultadoConsulta
     * @var string
     */
    public $ResultadoConsulta;
    /**
     * Constructor method for RespuestaConsultaFacturaCobrosType
     * @uses RespuestaConsultaFacturaCobrosType::setIDFactura()
     * @uses RespuestaConsultaFacturaCobrosType::setIndicadorPaginacion()
     * @uses RespuestaConsultaFacturaCobrosType::setResultadoConsulta()
     * @param \StructType\IDFacturaExpedidaBCType $iDFactura
     * @param string $indicadorPaginacion
     * @param string $resultadoConsulta
     */
    public function __construct(\StructType\IDFacturaExpedidaBCType $iDFactura = null, $indicadorPaginacion = null, $resultadoConsulta = null)
    {
        $this
            ->setIDFactura($iDFactura)
            ->setIndicadorPaginacion($indicadorPaginacion)
            ->setResultadoConsulta($resultadoConsulta);
    }
    /**
     * Get IDFactura value
     * @return \StructType\IDFacturaExpedidaBCType|null
     */
    public function getIDFactura()
    {
        return $this->IDFactura;
    }
    /**
     * Set IDFactura value
     * @param \StructType\IDFacturaExpedidaBCType $iDFactura
     * @return \StructType\RespuestaConsultaFacturaCobrosType
     */
    public function setIDFactura(\StructType\IDFacturaExpedidaBCType $iDFactura = null)
    {
        $this->IDFactura = $iDFactura;
        return $this;
    }
    /**
     * Get IndicadorPaginacion value
     * @return string|null
     */
    public function getIndicadorPaginacion()
    {
        return $this->IndicadorPaginacion;
    }
    /**
     * Set IndicadorPaginacion value
     * @uses \EnumType\IndicadorPaginacionType::valueIsValid()
     * @uses \EnumType\IndicadorPaginacionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $indicadorPaginacion
     * @return \StructType\RespuestaConsultaFacturaCobrosType
     */
    public function setIndicadorPaginacion($indicadorPaginacion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndicadorPaginacionType::valueIsValid($indicadorPaginacion)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $indicadorPaginacion, implode(', ', \EnumType\IndicadorPaginacionType::getValidValues())), __LINE__);
        }
        $this->IndicadorPaginacion = $indicadorPaginacion;
        return $this;
    }
    /**
     * Get ResultadoConsulta value
     * @return string|null
     */
    public function getResultadoConsulta()
    {
        return $this->ResultadoConsulta;
    }
    /**
     * Set ResultadoConsulta value
     * @uses \EnumType\ResultadoConsultaType::valueIsValid()
     * @uses \EnumType\ResultadoConsultaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultadoConsulta
     * @return \StructType\RespuestaConsultaFacturaCobrosType
     */
    public function setResultadoConsulta($resultadoConsulta = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResultadoConsultaType::valueIsValid($resultadoConsulta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resultadoConsulta, implode(', ', \EnumType\ResultadoConsultaType::getValidValues())), __LINE__);
        }
        $this->ResultadoConsulta = $resultadoConsulta;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespuestaConsultaFacturaCobrosType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
