<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaComunitariaType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Respuesta a un envío Sii
 * @subpackage Structs
 */
class RespuestaComunitariaType extends AbstractStructBase
{
    /**
     * The IDFactura
     * Meta informations extracted from the WSDL
     * - documentation: Contraparte
     * @var \StructType\IDFacturaComunitariaType
     */
    public $IDFactura;
    /**
     * The EstadoRegistro
     * Meta informations extracted from the WSDL
     * - documentation: Estado del registro. Correcto, erróneo o aceptado con errores
     * @var string
     */
    public $EstadoRegistro;
    /**
     * The CodigoErrorRegistro
     * Meta informations extracted from the WSDL
     * - documentation: Código del error de registro, en su caso.
     * - minOccurs: 0
     * @var int
     */
    public $CodigoErrorRegistro;
    /**
     * The DescripcionErrorRegistro
     * Meta informations extracted from the WSDL
     * - documentation: Descripción detallada del error de registro, en su caso.
     * - minOccurs: 0
     * - maxLength: 500
     * @var string
     */
    public $DescripcionErrorRegistro;
    /**
     * Constructor method for RespuestaComunitariaType
     * @uses RespuestaComunitariaType::setIDFactura()
     * @uses RespuestaComunitariaType::setEstadoRegistro()
     * @uses RespuestaComunitariaType::setCodigoErrorRegistro()
     * @uses RespuestaComunitariaType::setDescripcionErrorRegistro()
     * @param \StructType\IDFacturaComunitariaType $iDFactura
     * @param string $estadoRegistro
     * @param int $codigoErrorRegistro
     * @param string $descripcionErrorRegistro
     */
    public function __construct(\StructType\IDFacturaComunitariaType $iDFactura = null, $estadoRegistro = null, $codigoErrorRegistro = null, $descripcionErrorRegistro = null)
    {
        $this
            ->setIDFactura($iDFactura)
            ->setEstadoRegistro($estadoRegistro)
            ->setCodigoErrorRegistro($codigoErrorRegistro)
            ->setDescripcionErrorRegistro($descripcionErrorRegistro);
    }
    /**
     * Get IDFactura value
     * @return \StructType\IDFacturaComunitariaType|null
     */
    public function getIDFactura()
    {
        return $this->IDFactura;
    }
    /**
     * Set IDFactura value
     * @param \StructType\IDFacturaComunitariaType $iDFactura
     * @return \StructType\RespuestaComunitariaType
     */
    public function setIDFactura(\StructType\IDFacturaComunitariaType $iDFactura = null)
    {
        $this->IDFactura = $iDFactura;
        return $this;
    }
    /**
     * Get EstadoRegistro value
     * @return string|null
     */
    public function getEstadoRegistro()
    {
        return $this->EstadoRegistro;
    }
    /**
     * Set EstadoRegistro value
     * @uses \EnumType\EstadoRegistroType::valueIsValid()
     * @uses \EnumType\EstadoRegistroType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $estadoRegistro
     * @return \StructType\RespuestaComunitariaType
     */
    public function setEstadoRegistro($estadoRegistro = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EstadoRegistroType::valueIsValid($estadoRegistro)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $estadoRegistro, implode(', ', \EnumType\EstadoRegistroType::getValidValues())), __LINE__);
        }
        $this->EstadoRegistro = $estadoRegistro;
        return $this;
    }
    /**
     * Get CodigoErrorRegistro value
     * @return int|null
     */
    public function getCodigoErrorRegistro()
    {
        return $this->CodigoErrorRegistro;
    }
    /**
     * Set CodigoErrorRegistro value
     * @param int $codigoErrorRegistro
     * @return \StructType\RespuestaComunitariaType
     */
    public function setCodigoErrorRegistro($codigoErrorRegistro = null)
    {
        // validation for constraint: int
        if (!is_null($codigoErrorRegistro) && !is_numeric($codigoErrorRegistro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoErrorRegistro)), __LINE__);
        }
        $this->CodigoErrorRegistro = $codigoErrorRegistro;
        return $this;
    }
    /**
     * Get DescripcionErrorRegistro value
     * @return string|null
     */
    public function getDescripcionErrorRegistro()
    {
        return $this->DescripcionErrorRegistro;
    }
    /**
     * Set DescripcionErrorRegistro value
     * @param string $descripcionErrorRegistro
     * @return \StructType\RespuestaComunitariaType
     */
    public function setDescripcionErrorRegistro($descripcionErrorRegistro = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descripcionErrorRegistro) && strlen($descripcionErrorRegistro) > 500) || (is_array($descripcionErrorRegistro) && count($descripcionErrorRegistro) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($descripcionErrorRegistro) ? strlen($descripcionErrorRegistro) : count($descripcionErrorRegistro)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descripcionErrorRegistro) && !is_string($descripcionErrorRegistro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descripcionErrorRegistro)), __LINE__);
        }
        $this->DescripcionErrorRegistro = $descripcionErrorRegistro;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespuestaComunitariaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
