<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaComunAltaType StructType
 * @subpackage Structs
 */
class RespuestaComunAltaType extends AbstractStructBase
{
    /**
     * The CSV
     * Meta informations extracted from the WSDL
     * - documentation: CSV asociado al envío generado por AEAT. Solo se genera si no hay rechazo del envio
     * - minOccurs: 0
     * @var string
     */
    public $CSV;
    /**
     * The DatosPresentacion
     * Meta informations extracted from the WSDL
     * - documentation: Se devuelven datos de la presentacion realizada. Solo se genera si no hay rechazo del envio
     * - minOccurs: 0
     * @var \StructType\DatosPresentacionType
     */
    public $DatosPresentacion;
    /**
     * The Cabecera
     * Meta informations extracted from the WSDL
     * - documentation: Se devuelve la cabecera que se incluó en el envío.
     * @var \StructType\CabeceraSii
     */
    public $Cabecera;
    /**
     * The EstadoEnvio
     * Meta informations extracted from the WSDL
     * - documentation: Estado del envío en conjunto. Si los datos de cabecera y todos los registros son correctos,el estado es correcto. En caso de estructura y cabecera correctos donde todos los registros son incorrectos, el estado es incorrecto En caso
     * de estructura y cabecera correctos con al menos un registro incorrecto o aceptado con errores, el estado global es parcialmente correcto.
     * @var string
     */
    public $EstadoEnvio;
    /**
     * Constructor method for RespuestaComunAltaType
     * @uses RespuestaComunAltaType::setCSV()
     * @uses RespuestaComunAltaType::setDatosPresentacion()
     * @uses RespuestaComunAltaType::setCabecera()
     * @uses RespuestaComunAltaType::setEstadoEnvio()
     * @param string $cSV
     * @param \StructType\DatosPresentacionType $datosPresentacion
     * @param \StructType\CabeceraSii $cabecera
     * @param string $estadoEnvio
     */
    public function __construct($cSV = null, \StructType\DatosPresentacionType $datosPresentacion = null, \StructType\CabeceraSii $cabecera = null, $estadoEnvio = null)
    {
        $this
            ->setCSV($cSV)
            ->setDatosPresentacion($datosPresentacion)
            ->setCabecera($cabecera)
            ->setEstadoEnvio($estadoEnvio);
    }
    /**
     * Get CSV value
     * @return string|null
     */
    public function getCSV()
    {
        return $this->CSV;
    }
    /**
     * Set CSV value
     * @param string $cSV
     * @return \StructType\RespuestaComunAltaType
     */
    public function setCSV($cSV = null)
    {
        // validation for constraint: string
        if (!is_null($cSV) && !is_string($cSV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cSV)), __LINE__);
        }
        $this->CSV = $cSV;
        return $this;
    }
    /**
     * Get DatosPresentacion value
     * @return \StructType\DatosPresentacionType|null
     */
    public function getDatosPresentacion()
    {
        return $this->DatosPresentacion;
    }
    /**
     * Set DatosPresentacion value
     * @param \StructType\DatosPresentacionType $datosPresentacion
     * @return \StructType\RespuestaComunAltaType
     */
    public function setDatosPresentacion(\StructType\DatosPresentacionType $datosPresentacion = null)
    {
        $this->DatosPresentacion = $datosPresentacion;
        return $this;
    }
    /**
     * Get Cabecera value
     * @return \StructType\CabeceraSii|null
     */
    public function getCabecera()
    {
        return $this->Cabecera;
    }
    /**
     * Set Cabecera value
     * @param \StructType\CabeceraSii $cabecera
     * @return \StructType\RespuestaComunAltaType
     */
    public function setCabecera(\StructType\CabeceraSii $cabecera = null)
    {
        $this->Cabecera = $cabecera;
        return $this;
    }
    /**
     * Get EstadoEnvio value
     * @return string|null
     */
    public function getEstadoEnvio()
    {
        return $this->EstadoEnvio;
    }
    /**
     * Set EstadoEnvio value
     * @uses \EnumType\EstadoEnvioType::valueIsValid()
     * @uses \EnumType\EstadoEnvioType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $estadoEnvio
     * @return \StructType\RespuestaComunAltaType
     */
    public function setEstadoEnvio($estadoEnvio = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EstadoEnvioType::valueIsValid($estadoEnvio)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $estadoEnvio, implode(', ', \EnumType\EstadoEnvioType::getValidValues())), __LINE__);
        }
        $this->EstadoEnvio = $estadoEnvio;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespuestaComunAltaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
