<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PeriodoImpositivo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Período al que corresponden los apuntes. todos los apuntes deben corresponder al mismo período impositivo | Período al que corresponden los apuntes. todos los apuntes deben corresponder al mismo período impositivo | Período al
 * que corresponden los apuntes. todos los apuntes deben corresponder al mismo período impositivo
 * @subpackage Structs
 */
class PeriodoImpositivo extends AbstractStructBase
{
    /**
     * The Ejercicio
     * Meta informations extracted from the WSDL
     * - documentation: Año en formato YYYY
     * - length: 4
     * - pattern: \d{4,4}
     * @var string
     */
    public $Ejercicio;
    /**
     * The Periodo
     * @var string
     */
    public $Periodo;
    /**
     * Constructor method for PeriodoImpositivo
     * @uses PeriodoImpositivo::setEjercicio()
     * @uses PeriodoImpositivo::setPeriodo()
     * @param string $ejercicio
     * @param string $periodo
     */
    public function __construct($ejercicio = null, $periodo = null)
    {
        $this
            ->setEjercicio($ejercicio)
            ->setPeriodo($periodo);
    }
    /**
     * Get Ejercicio value
     * @return string|null
     */
    public function getEjercicio()
    {
        return $this->Ejercicio;
    }
    /**
     * Set Ejercicio value
     * @param string $ejercicio
     * @return \StructType\PeriodoImpositivo
     */
    public function setEjercicio($ejercicio = null)
    {
        // validation for constraint: length
        if ((is_scalar($ejercicio) && strlen($ejercicio) !== 4) || (is_array($ejercicio) && count($ejercicio) !== 4)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ejercicio) && !preg_match('/\d{4,4}/', $ejercicio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{4,4}", "%s" given', var_export($ejercicio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ejercicio) && !is_string($ejercicio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ejercicio)), __LINE__);
        }
        $this->Ejercicio = $ejercicio;
        return $this;
    }
    /**
     * Get Periodo value
     * @return string|null
     */
    public function getPeriodo()
    {
        return $this->Periodo;
    }
    /**
     * Set Periodo value
     * @uses \EnumType\TipoPeriodoType::valueIsValid()
     * @uses \EnumType\TipoPeriodoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodo
     * @return \StructType\PeriodoImpositivo
     */
    public function setPeriodo($periodo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoPeriodoType::valueIsValid($periodo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $periodo, implode(', ', \EnumType\TipoPeriodoType::getValidValues())), __LINE__);
        }
        $this->Periodo = $periodo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PeriodoImpositivo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
