<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagosType StructType
 * @subpackage Structs
 */
class PagosType extends AbstractStructBase
{
    /**
     * The Pago
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\DatosPagoCobroType[]
     */
    public $Pago;
    /**
     * Constructor method for PagosType
     * @uses PagosType::setPago()
     * @param \StructType\DatosPagoCobroType[] $pago
     */
    public function __construct(array $pago = array())
    {
        $this
            ->setPago($pago);
    }
    /**
     * Get Pago value
     * @return \StructType\DatosPagoCobroType[]|null
     */
    public function getPago()
    {
        return $this->Pago;
    }
    /**
     * Set Pago value
     * @throws \InvalidArgumentException
     * @param \StructType\DatosPagoCobroType[] $pago
     * @return \StructType\PagosType
     */
    public function setPago(array $pago = array())
    {
        foreach ($pago as $pagosTypePagoItem) {
            // validation for constraint: itemType
            if (!$pagosTypePagoItem instanceof \StructType\DatosPagoCobroType) {
                throw new \InvalidArgumentException(sprintf('The Pago property can only contain items of \StructType\DatosPagoCobroType, "%s" given', is_object($pagosTypePagoItem) ? get_class($pagosTypePagoItem) : gettype($pagosTypePagoItem)), __LINE__);
            }
        }
        $this->Pago = $pago;
        return $this;
    }
    /**
     * Add item to Pago value
     * @throws \InvalidArgumentException
     * @param \StructType\DatosPagoCobroType $item
     * @return \StructType\PagosType
     */
    public function addToPago(\StructType\DatosPagoCobroType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatosPagoCobroType) {
            throw new \InvalidArgumentException(sprintf('The Pago property can only contain items of \StructType\DatosPagoCobroType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Pago[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PagosType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
