<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperacionIntracomunitariaType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Apunte correspondiente al libro de operaciones intracomunitarias.
 * @subpackage Structs
 */
class OperacionIntracomunitariaType extends AbstractStructBase
{
    /**
     * The TipoOperacion
     * @var string
     */
    public $TipoOperacion;
    /**
     * The ClaveDeclarado
     * @var string
     */
    public $ClaveDeclarado;
    /**
     * The EstadoMiembro
     * @var string
     */
    public $EstadoMiembro;
    /**
     * The PlazoOperacion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: \d{1,3}
     * @var string
     */
    public $PlazoOperacion;
    /**
     * The DescripcionBienes
     * Meta informations extracted from the WSDL
     * - maxLength: 40
     * @var string
     */
    public $DescripcionBienes;
    /**
     * The DireccionOperador
     * Meta informations extracted from the WSDL
     * - maxLength: 120
     * @var string
     */
    public $DireccionOperador;
    /**
     * The FacturasODocumentacion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 150
     * @var string
     */
    public $FacturasODocumentacion;
    /**
     * Constructor method for OperacionIntracomunitariaType
     * @uses OperacionIntracomunitariaType::setTipoOperacion()
     * @uses OperacionIntracomunitariaType::setClaveDeclarado()
     * @uses OperacionIntracomunitariaType::setEstadoMiembro()
     * @uses OperacionIntracomunitariaType::setPlazoOperacion()
     * @uses OperacionIntracomunitariaType::setDescripcionBienes()
     * @uses OperacionIntracomunitariaType::setDireccionOperador()
     * @uses OperacionIntracomunitariaType::setFacturasODocumentacion()
     * @param string $tipoOperacion
     * @param string $claveDeclarado
     * @param string $estadoMiembro
     * @param string $plazoOperacion
     * @param string $descripcionBienes
     * @param string $direccionOperador
     * @param string $facturasODocumentacion
     */
    public function __construct($tipoOperacion = null, $claveDeclarado = null, $estadoMiembro = null, $plazoOperacion = null, $descripcionBienes = null, $direccionOperador = null, $facturasODocumentacion = null)
    {
        $this
            ->setTipoOperacion($tipoOperacion)
            ->setClaveDeclarado($claveDeclarado)
            ->setEstadoMiembro($estadoMiembro)
            ->setPlazoOperacion($plazoOperacion)
            ->setDescripcionBienes($descripcionBienes)
            ->setDireccionOperador($direccionOperador)
            ->setFacturasODocumentacion($facturasODocumentacion);
    }
    /**
     * Get TipoOperacion value
     * @return string|null
     */
    public function getTipoOperacion()
    {
        return $this->TipoOperacion;
    }
    /**
     * Set TipoOperacion value
     * @uses \EnumType\TipoOperacion::valueIsValid()
     * @uses \EnumType\TipoOperacion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoOperacion
     * @return \StructType\OperacionIntracomunitariaType
     */
    public function setTipoOperacion($tipoOperacion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoOperacion::valueIsValid($tipoOperacion)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoOperacion, implode(', ', \EnumType\TipoOperacion::getValidValues())), __LINE__);
        }
        $this->TipoOperacion = $tipoOperacion;
        return $this;
    }
    /**
     * Get ClaveDeclarado value
     * @return string|null
     */
    public function getClaveDeclarado()
    {
        return $this->ClaveDeclarado;
    }
    /**
     * Set ClaveDeclarado value
     * @uses \EnumType\ClaveDeclarado::valueIsValid()
     * @uses \EnumType\ClaveDeclarado::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claveDeclarado
     * @return \StructType\OperacionIntracomunitariaType
     */
    public function setClaveDeclarado($claveDeclarado = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClaveDeclarado::valueIsValid($claveDeclarado)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $claveDeclarado, implode(', ', \EnumType\ClaveDeclarado::getValidValues())), __LINE__);
        }
        $this->ClaveDeclarado = $claveDeclarado;
        return $this;
    }
    /**
     * Get EstadoMiembro value
     * @return string|null
     */
    public function getEstadoMiembro()
    {
        return $this->EstadoMiembro;
    }
    /**
     * Set EstadoMiembro value
     * @uses \EnumType\CountryMiembroType::valueIsValid()
     * @uses \EnumType\CountryMiembroType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $estadoMiembro
     * @return \StructType\OperacionIntracomunitariaType
     */
    public function setEstadoMiembro($estadoMiembro = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryMiembroType::valueIsValid($estadoMiembro)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $estadoMiembro, implode(', ', \EnumType\CountryMiembroType::getValidValues())), __LINE__);
        }
        $this->EstadoMiembro = $estadoMiembro;
        return $this;
    }
    /**
     * Get PlazoOperacion value
     * @return string|null
     */
    public function getPlazoOperacion()
    {
        return $this->PlazoOperacion;
    }
    /**
     * Set PlazoOperacion value
     * @param string $plazoOperacion
     * @return \StructType\OperacionIntracomunitariaType
     */
    public function setPlazoOperacion($plazoOperacion = null)
    {
        // validation for constraint: pattern
        if (is_scalar($plazoOperacion) && !preg_match('/\d{1,3}/', $plazoOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{1,3}", "%s" given', var_export($plazoOperacion, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($plazoOperacion) && !is_string($plazoOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plazoOperacion)), __LINE__);
        }
        $this->PlazoOperacion = $plazoOperacion;
        return $this;
    }
    /**
     * Get DescripcionBienes value
     * @return string|null
     */
    public function getDescripcionBienes()
    {
        return $this->DescripcionBienes;
    }
    /**
     * Set DescripcionBienes value
     * @param string $descripcionBienes
     * @return \StructType\OperacionIntracomunitariaType
     */
    public function setDescripcionBienes($descripcionBienes = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descripcionBienes) && strlen($descripcionBienes) > 40) || (is_array($descripcionBienes) && count($descripcionBienes) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($descripcionBienes) ? strlen($descripcionBienes) : count($descripcionBienes)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descripcionBienes) && !is_string($descripcionBienes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descripcionBienes)), __LINE__);
        }
        $this->DescripcionBienes = $descripcionBienes;
        return $this;
    }
    /**
     * Get DireccionOperador value
     * @return string|null
     */
    public function getDireccionOperador()
    {
        return $this->DireccionOperador;
    }
    /**
     * Set DireccionOperador value
     * @param string $direccionOperador
     * @return \StructType\OperacionIntracomunitariaType
     */
    public function setDireccionOperador($direccionOperador = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($direccionOperador) && strlen($direccionOperador) > 120) || (is_array($direccionOperador) && count($direccionOperador) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($direccionOperador) ? strlen($direccionOperador) : count($direccionOperador)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($direccionOperador) && !is_string($direccionOperador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direccionOperador)), __LINE__);
        }
        $this->DireccionOperador = $direccionOperador;
        return $this;
    }
    /**
     * Get FacturasODocumentacion value
     * @return string|null
     */
    public function getFacturasODocumentacion()
    {
        return $this->FacturasODocumentacion;
    }
    /**
     * Set FacturasODocumentacion value
     * @param string $facturasODocumentacion
     * @return \StructType\OperacionIntracomunitariaType
     */
    public function setFacturasODocumentacion($facturasODocumentacion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($facturasODocumentacion) && strlen($facturasODocumentacion) > 150) || (is_array($facturasODocumentacion) && count($facturasODocumentacion) > 150)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 150 element(s) or a scalar of 150 character(s) at most, "%d" length given', is_scalar($facturasODocumentacion) ? strlen($facturasODocumentacion) : count($facturasODocumentacion)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($facturasODocumentacion) && !is_string($facturasODocumentacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($facturasODocumentacion)), __LINE__);
        }
        $this->FacturasODocumentacion = $facturasODocumentacion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperacionIntracomunitariaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
