<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IDOtroType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Identificador de persona Física o jurídica distinto del NIF (Código pais, Tipo de Identificador, y hasta 15 caractéres) No se permite CodigoPais=ES e IDType=01-NIFContraparte para ese caso, debe utilizarse NIF en lugar de IDOtro.
 * @subpackage Structs
 */
class IDOtroType extends AbstractStructBase
{
    /**
     * The CodigoPais
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPais;
    /**
     * The IDType
     * @var string
     */
    public $IDType;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * @var string
     */
    public $ID;
    /**
     * Constructor method for IDOtroType
     * @uses IDOtroType::setCodigoPais()
     * @uses IDOtroType::setIDType()
     * @uses IDOtroType::setID()
     * @param string $codigoPais
     * @param string $iDType
     * @param string $iD
     */
    public function __construct($codigoPais = null, $iDType = null, $iD = null)
    {
        $this
            ->setCodigoPais($codigoPais)
            ->setIDType($iDType)
            ->setID($iD);
    }
    /**
     * Get CodigoPais value
     * @return string|null
     */
    public function getCodigoPais()
    {
        return $this->CodigoPais;
    }
    /**
     * Set CodigoPais value
     * @uses \EnumType\CountryType2::valueIsValid()
     * @uses \EnumType\CountryType2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codigoPais
     * @return \StructType\IDOtroType
     */
    public function setCodigoPais($codigoPais = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryType2::valueIsValid($codigoPais)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $codigoPais, implode(', ', \EnumType\CountryType2::getValidValues())), __LINE__);
        }
        $this->CodigoPais = $codigoPais;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \EnumType\PersonaFisicaJuridicaIDTypeType::valueIsValid()
     * @uses \EnumType\PersonaFisicaJuridicaIDTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \StructType\IDOtroType
     */
    public function setIDType($iDType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PersonaFisicaJuridicaIDTypeType::valueIsValid($iDType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iDType, implode(', ', \EnumType\PersonaFisicaJuridicaIDTypeType::getValidValues())), __LINE__);
        }
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\IDOtroType
     */
    public function setID($iD = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iD) && strlen($iD) > 20) || (is_array($iD) && count($iD) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($iD) ? strlen($iD) : count($iD)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IDOtroType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
