<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IDEmisorFactura StructType
 * @subpackage Structs
 */
class IDEmisorFactura extends AbstractStructBase
{
    /**
     * The NombreRazon
     * Meta informations extracted from the WSDL
     * - maxLength: 40
     * @var string
     */
    public $NombreRazon;
    /**
     * The NIF
     * Meta informations extracted from the WSDL
     * - documentation: NIF: Secuencia de 9 dígitos o letras mayúsculas
     * - length: 9
     * - pattern: (([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))
     * @var string
     */
    public $NIF;
    /**
     * The IDOtro
     * @var \StructType\IDOtroType
     */
    public $IDOtro;
    /**
     * Constructor method for IDEmisorFactura
     * @uses IDEmisorFactura::setNombreRazon()
     * @uses IDEmisorFactura::setNIF()
     * @uses IDEmisorFactura::setIDOtro()
     * @param string $nombreRazon
     * @param string $nIF
     * @param \StructType\IDOtroType $iDOtro
     */
    public function __construct($nombreRazon = null, $nIF = null, \StructType\IDOtroType $iDOtro = null)
    {
        $this
            ->setNombreRazon($nombreRazon)
            ->setNIF($nIF)
            ->setIDOtro($iDOtro);
    }
    /**
     * Get NombreRazon value
     * @return string|null
     */
    public function getNombreRazon()
    {
        return $this->NombreRazon;
    }
    /**
     * Set NombreRazon value
     * @param string $nombreRazon
     * @return \StructType\IDEmisorFactura
     */
    public function setNombreRazon($nombreRazon = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nombreRazon) && strlen($nombreRazon) > 40) || (is_array($nombreRazon) && count($nombreRazon) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($nombreRazon) ? strlen($nombreRazon) : count($nombreRazon)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nombreRazon) && !is_string($nombreRazon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombreRazon)), __LINE__);
        }
        $this->NombreRazon = $nombreRazon;
        return $this;
    }
    /**
     * Get NIF value
     * @return string|null
     */
    public function getNIF()
    {
        return $this->NIF;
    }
    /**
     * Set NIF value
     * @param string $nIF
     * @return \StructType\IDEmisorFactura
     */
    public function setNIF($nIF = null)
    {
        // validation for constraint: length
        if ((is_scalar($nIF) && strlen($nIF) !== 9) || (is_array($nIF) && count($nIF) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($nIF) && !preg_match('/(([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))/', $nIF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))", "%s" given', var_export($nIF, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nIF) && !is_string($nIF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nIF)), __LINE__);
        }
        $this->NIF = $nIF;
        return $this;
    }
    /**
     * Get IDOtro value
     * @return \StructType\IDOtroType|null
     */
    public function getIDOtro()
    {
        return $this->IDOtro;
    }
    /**
     * Set IDOtro value
     * @param \StructType\IDOtroType $iDOtro
     * @return \StructType\IDEmisorFactura
     */
    public function setIDOtro(\StructType\IDOtroType $iDOtro = null)
    {
        $this->IDOtro = $iDOtro;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IDEmisorFactura
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
