<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacturaRespuestaExpedidaType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Apunte correspondiente al libro de facturas expedidas.
 * @subpackage Structs
 */
class FacturaRespuestaExpedidaType extends FacturaRespuestaType
{
    /**
     * The DatosInmueble
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DatosInmueble
     */
    public $DatosInmueble;
    /**
     * The ImporteTransmisionSujetoAIVA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $ImporteTransmisionSujetoAIVA;
    /**
     * The EmitidaPorTerceros
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EmitidaPorTerceros;
    /**
     * The Contraparte
     * Meta informations extracted from the WSDL
     * - documentation: Contraparte de la operación. Cliente (Opcional en tiquets) en facturas emitidas.
     * - minOccurs: 0
     * @var \StructType\PersonaFisicaJuridicaType
     */
    public $Contraparte;
    /**
     * The TipoDesglose
     * @var \StructType\TipoDesglose
     */
    public $TipoDesglose;
    /**
     * The Cobros
     * @var string
     */
    public $Cobros;
    /**
     * Constructor method for FacturaRespuestaExpedidaType
     * @uses FacturaRespuestaExpedidaType::setDatosInmueble()
     * @uses FacturaRespuestaExpedidaType::setImporteTransmisionSujetoAIVA()
     * @uses FacturaRespuestaExpedidaType::setEmitidaPorTerceros()
     * @uses FacturaRespuestaExpedidaType::setContraparte()
     * @uses FacturaRespuestaExpedidaType::setTipoDesglose()
     * @uses FacturaRespuestaExpedidaType::setCobros()
     * @param \StructType\DatosInmueble $datosInmueble
     * @param string $importeTransmisionSujetoAIVA
     * @param string $emitidaPorTerceros
     * @param \StructType\PersonaFisicaJuridicaType $contraparte
     * @param \StructType\TipoDesglose $tipoDesglose
     * @param string $cobros
     */
    public function __construct(\StructType\DatosInmueble $datosInmueble = null, $importeTransmisionSujetoAIVA = null, $emitidaPorTerceros = null, \StructType\PersonaFisicaJuridicaType $contraparte = null, \StructType\TipoDesglose $tipoDesglose = null, $cobros = null)
    {
        $this
            ->setDatosInmueble($datosInmueble)
            ->setImporteTransmisionSujetoAIVA($importeTransmisionSujetoAIVA)
            ->setEmitidaPorTerceros($emitidaPorTerceros)
            ->setContraparte($contraparte)
            ->setTipoDesglose($tipoDesglose)
            ->setCobros($cobros);
    }
    /**
     * Get DatosInmueble value
     * @return \StructType\DatosInmueble|null
     */
    public function getDatosInmueble()
    {
        return $this->DatosInmueble;
    }
    /**
     * Set DatosInmueble value
     * @param \StructType\DatosInmueble $datosInmueble
     * @return \StructType\FacturaRespuestaExpedidaType
     */
    public function setDatosInmueble(\StructType\DatosInmueble $datosInmueble = null)
    {
        $this->DatosInmueble = $datosInmueble;
        return $this;
    }
    /**
     * Get ImporteTransmisionSujetoAIVA value
     * @return string|null
     */
    public function getImporteTransmisionSujetoAIVA()
    {
        return $this->ImporteTransmisionSujetoAIVA;
    }
    /**
     * Set ImporteTransmisionSujetoAIVA value
     * @param string $importeTransmisionSujetoAIVA
     * @return \StructType\FacturaRespuestaExpedidaType
     */
    public function setImporteTransmisionSujetoAIVA($importeTransmisionSujetoAIVA = null)
    {
        // validation for constraint: pattern
        if (is_scalar($importeTransmisionSujetoAIVA) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $importeTransmisionSujetoAIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($importeTransmisionSujetoAIVA, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($importeTransmisionSujetoAIVA) && !is_string($importeTransmisionSujetoAIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importeTransmisionSujetoAIVA)), __LINE__);
        }
        $this->ImporteTransmisionSujetoAIVA = $importeTransmisionSujetoAIVA;
        return $this;
    }
    /**
     * Get EmitidaPorTerceros value
     * @return string|null
     */
    public function getEmitidaPorTerceros()
    {
        return $this->EmitidaPorTerceros;
    }
    /**
     * Set EmitidaPorTerceros value
     * @uses \EnumType\EmitidaPorTercerosType::valueIsValid()
     * @uses \EnumType\EmitidaPorTercerosType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $emitidaPorTerceros
     * @return \StructType\FacturaRespuestaExpedidaType
     */
    public function setEmitidaPorTerceros($emitidaPorTerceros = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmitidaPorTercerosType::valueIsValid($emitidaPorTerceros)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $emitidaPorTerceros, implode(', ', \EnumType\EmitidaPorTercerosType::getValidValues())), __LINE__);
        }
        $this->EmitidaPorTerceros = $emitidaPorTerceros;
        return $this;
    }
    /**
     * Get Contraparte value
     * @return \StructType\PersonaFisicaJuridicaType|null
     */
    public function getContraparte()
    {
        return $this->Contraparte;
    }
    /**
     * Set Contraparte value
     * @param \StructType\PersonaFisicaJuridicaType $contraparte
     * @return \StructType\FacturaRespuestaExpedidaType
     */
    public function setContraparte(\StructType\PersonaFisicaJuridicaType $contraparte = null)
    {
        $this->Contraparte = $contraparte;
        return $this;
    }
    /**
     * Get TipoDesglose value
     * @return \StructType\TipoDesglose|null
     */
    public function getTipoDesglose()
    {
        return $this->TipoDesglose;
    }
    /**
     * Set TipoDesglose value
     * @param \StructType\TipoDesglose $tipoDesglose
     * @return \StructType\FacturaRespuestaExpedidaType
     */
    public function setTipoDesglose(\StructType\TipoDesglose $tipoDesglose = null)
    {
        $this->TipoDesglose = $tipoDesglose;
        return $this;
    }
    /**
     * Get Cobros value
     * @return string|null
     */
    public function getCobros()
    {
        return $this->Cobros;
    }
    /**
     * Set Cobros value
     * @uses \EnumType\FacturaARType::valueIsValid()
     * @uses \EnumType\FacturaARType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cobros
     * @return \StructType\FacturaRespuestaExpedidaType
     */
    public function setCobros($cobros = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FacturaARType::valueIsValid($cobros)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cobros, implode(', ', \EnumType\FacturaARType::getValidValues())), __LINE__);
        }
        $this->Cobros = $cobros;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacturaRespuestaExpedidaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
