<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacturaExpedidaType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Apunte correspondiente al libro de facturas expedidas.
 * @subpackage Structs
 */
class FacturaExpedidaType extends FacturaType
{
    /**
     * The DatosInmueble
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DatosInmueble
     */
    public $DatosInmueble;
    /**
     * The ImporteTransmisionSujetoAIVA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $ImporteTransmisionSujetoAIVA;
    /**
     * The EmitidaPorTerceros
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EmitidaPorTerceros;
    /**
     * The Contraparte
     * Meta informations extracted from the WSDL
     * - documentation: Contraparte de la operación. Cliente (Opcional en tiquets) en facturas emitidas.
     * - minOccurs: 0
     * @var \StructType\PersonaFisicaJuridicaType
     */
    public $Contraparte;
    /**
     * The TipoDesglose
     * @var \StructType\TipoDesglose
     */
    public $TipoDesglose;
    /**
     * Constructor method for FacturaExpedidaType
     * @uses FacturaExpedidaType::setDatosInmueble()
     * @uses FacturaExpedidaType::setImporteTransmisionSujetoAIVA()
     * @uses FacturaExpedidaType::setEmitidaPorTerceros()
     * @uses FacturaExpedidaType::setContraparte()
     * @uses FacturaExpedidaType::setTipoDesglose()
     * @param \StructType\DatosInmueble $datosInmueble
     * @param string $importeTransmisionSujetoAIVA
     * @param string $emitidaPorTerceros
     * @param \StructType\PersonaFisicaJuridicaType $contraparte
     * @param \StructType\TipoDesglose $tipoDesglose
     */
    public function __construct(\StructType\DatosInmueble $datosInmueble = null, $importeTransmisionSujetoAIVA = null, $emitidaPorTerceros = null, \StructType\PersonaFisicaJuridicaType $contraparte = null, \StructType\TipoDesglose $tipoDesglose = null)
    {
        $this
            ->setDatosInmueble($datosInmueble)
            ->setImporteTransmisionSujetoAIVA($importeTransmisionSujetoAIVA)
            ->setEmitidaPorTerceros($emitidaPorTerceros)
            ->setContraparte($contraparte)
            ->setTipoDesglose($tipoDesglose);
    }
    /**
     * Get DatosInmueble value
     * @return \StructType\DatosInmueble|null
     */
    public function getDatosInmueble()
    {
        return $this->DatosInmueble;
    }
    /**
     * Set DatosInmueble value
     * @param \StructType\DatosInmueble $datosInmueble
     * @return \StructType\FacturaExpedidaType
     */
    public function setDatosInmueble(\StructType\DatosInmueble $datosInmueble = null)
    {
        $this->DatosInmueble = $datosInmueble;
        return $this;
    }
    /**
     * Get ImporteTransmisionSujetoAIVA value
     * @return string|null
     */
    public function getImporteTransmisionSujetoAIVA()
    {
        return $this->ImporteTransmisionSujetoAIVA;
    }
    /**
     * Set ImporteTransmisionSujetoAIVA value
     * @param string $importeTransmisionSujetoAIVA
     * @return \StructType\FacturaExpedidaType
     */
    public function setImporteTransmisionSujetoAIVA($importeTransmisionSujetoAIVA = null)
    {
        // validation for constraint: pattern
        if (is_scalar($importeTransmisionSujetoAIVA) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $importeTransmisionSujetoAIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($importeTransmisionSujetoAIVA, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($importeTransmisionSujetoAIVA) && !is_string($importeTransmisionSujetoAIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importeTransmisionSujetoAIVA)), __LINE__);
        }
        $this->ImporteTransmisionSujetoAIVA = $importeTransmisionSujetoAIVA;
        return $this;
    }
    /**
     * Get EmitidaPorTerceros value
     * @return string|null
     */
    public function getEmitidaPorTerceros()
    {
        return $this->EmitidaPorTerceros;
    }
    /**
     * Set EmitidaPorTerceros value
     * @uses \EnumType\EmitidaPorTercerosType::valueIsValid()
     * @uses \EnumType\EmitidaPorTercerosType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $emitidaPorTerceros
     * @return \StructType\FacturaExpedidaType
     */
    public function setEmitidaPorTerceros($emitidaPorTerceros = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmitidaPorTercerosType::valueIsValid($emitidaPorTerceros)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $emitidaPorTerceros, implode(', ', \EnumType\EmitidaPorTercerosType::getValidValues())), __LINE__);
        }
        $this->EmitidaPorTerceros = $emitidaPorTerceros;
        return $this;
    }
    /**
     * Get Contraparte value
     * @return \StructType\PersonaFisicaJuridicaType|null
     */
    public function getContraparte()
    {
        return $this->Contraparte;
    }
    /**
     * Set Contraparte value
     * @param \StructType\PersonaFisicaJuridicaType $contraparte
     * @return \StructType\FacturaExpedidaType
     */
    public function setContraparte(\StructType\PersonaFisicaJuridicaType $contraparte = null)
    {
        $this->Contraparte = $contraparte;
        return $this;
    }
    /**
     * Get TipoDesglose value
     * @return \StructType\TipoDesglose|null
     */
    public function getTipoDesglose()
    {
        return $this->TipoDesglose;
    }
    /**
     * Set TipoDesglose value
     * @param \StructType\TipoDesglose $tipoDesglose
     * @return \StructType\FacturaExpedidaType
     */
    public function setTipoDesglose(\StructType\TipoDesglose $tipoDesglose = null)
    {
        $this->TipoDesglose = $tipoDesglose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacturaExpedidaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
