<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Exenta StructType
 * @subpackage Structs
 */
class Exenta extends AbstractStructBase
{
    /**
     * The CausaExencion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CausaExencion;
    /**
     * The BaseImponible
     * Meta informations extracted from the WSDL
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $BaseImponible;
    /**
     * Constructor method for Exenta
     * @uses Exenta::setCausaExencion()
     * @uses Exenta::setBaseImponible()
     * @param string $causaExencion
     * @param string $baseImponible
     */
    public function __construct($causaExencion = null, $baseImponible = null)
    {
        $this
            ->setCausaExencion($causaExencion)
            ->setBaseImponible($baseImponible);
    }
    /**
     * Get CausaExencion value
     * @return string|null
     */
    public function getCausaExencion()
    {
        return $this->CausaExencion;
    }
    /**
     * Set CausaExencion value
     * @uses \EnumType\CausaExencionType::valueIsValid()
     * @uses \EnumType\CausaExencionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $causaExencion
     * @return \StructType\Exenta
     */
    public function setCausaExencion($causaExencion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CausaExencionType::valueIsValid($causaExencion)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $causaExencion, implode(', ', \EnumType\CausaExencionType::getValidValues())), __LINE__);
        }
        $this->CausaExencion = $causaExencion;
        return $this;
    }
    /**
     * Get BaseImponible value
     * @return string|null
     */
    public function getBaseImponible()
    {
        return $this->BaseImponible;
    }
    /**
     * Set BaseImponible value
     * @param string $baseImponible
     * @return \StructType\Exenta
     */
    public function setBaseImponible($baseImponible = null)
    {
        // validation for constraint: pattern
        if (is_scalar($baseImponible) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $baseImponible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($baseImponible, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($baseImponible) && !is_string($baseImponible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseImponible)), __LINE__);
        }
        $this->BaseImponible = $baseImponible;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Exenta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
