<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DesgloseRectificacionType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Desglose de Base y Cuota sustituida en las Facturas Rectificativas sustitutivas
 * @subpackage Structs
 */
class DesgloseRectificacionType extends AbstractStructBase
{
    /**
     * The BaseRectificada
     * Meta informations extracted from the WSDL
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $BaseRectificada;
    /**
     * The CuotaRectificada
     * Meta informations extracted from the WSDL
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $CuotaRectificada;
    /**
     * The CuotaRecargoRectificado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $CuotaRecargoRectificado;
    /**
     * Constructor method for DesgloseRectificacionType
     * @uses DesgloseRectificacionType::setBaseRectificada()
     * @uses DesgloseRectificacionType::setCuotaRectificada()
     * @uses DesgloseRectificacionType::setCuotaRecargoRectificado()
     * @param string $baseRectificada
     * @param string $cuotaRectificada
     * @param string $cuotaRecargoRectificado
     */
    public function __construct($baseRectificada = null, $cuotaRectificada = null, $cuotaRecargoRectificado = null)
    {
        $this
            ->setBaseRectificada($baseRectificada)
            ->setCuotaRectificada($cuotaRectificada)
            ->setCuotaRecargoRectificado($cuotaRecargoRectificado);
    }
    /**
     * Get BaseRectificada value
     * @return string|null
     */
    public function getBaseRectificada()
    {
        return $this->BaseRectificada;
    }
    /**
     * Set BaseRectificada value
     * @param string $baseRectificada
     * @return \StructType\DesgloseRectificacionType
     */
    public function setBaseRectificada($baseRectificada = null)
    {
        // validation for constraint: pattern
        if (is_scalar($baseRectificada) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $baseRectificada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($baseRectificada, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($baseRectificada) && !is_string($baseRectificada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseRectificada)), __LINE__);
        }
        $this->BaseRectificada = $baseRectificada;
        return $this;
    }
    /**
     * Get CuotaRectificada value
     * @return string|null
     */
    public function getCuotaRectificada()
    {
        return $this->CuotaRectificada;
    }
    /**
     * Set CuotaRectificada value
     * @param string $cuotaRectificada
     * @return \StructType\DesgloseRectificacionType
     */
    public function setCuotaRectificada($cuotaRectificada = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cuotaRectificada) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $cuotaRectificada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($cuotaRectificada, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cuotaRectificada) && !is_string($cuotaRectificada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cuotaRectificada)), __LINE__);
        }
        $this->CuotaRectificada = $cuotaRectificada;
        return $this;
    }
    /**
     * Get CuotaRecargoRectificado value
     * @return string|null
     */
    public function getCuotaRecargoRectificado()
    {
        return $this->CuotaRecargoRectificado;
    }
    /**
     * Set CuotaRecargoRectificado value
     * @param string $cuotaRecargoRectificado
     * @return \StructType\DesgloseRectificacionType
     */
    public function setCuotaRecargoRectificado($cuotaRecargoRectificado = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cuotaRecargoRectificado) && !preg_match('/(\+|-)?\d{1,12}(\.\d{0,2})?/', $cuotaRecargoRectificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(\+|-)?\d{1,12}(\.\d{0,2})?", "%s" given', var_export($cuotaRecargoRectificado, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cuotaRecargoRectificado) && !is_string($cuotaRecargoRectificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cuotaRecargoRectificado)), __LINE__);
        }
        $this->CuotaRecargoRectificado = $cuotaRecargoRectificado;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DesgloseRectificacionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
