<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DesgloseIVA StructType
 * Meta informations extracted from the WSDL
 * - documentation: Desglose por tipos de iva | Desglose por tipos de iva | Desglose por tipos de iva
 * @subpackage Structs
 */
class DesgloseIVA extends AbstractStructBase
{
    /**
     * The DetalleIVA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 6
     * @var \StructType\DetalleIVARecibidaType[]
     */
    public $DetalleIVA;
    /**
     * Constructor method for DesgloseIVA
     * @uses DesgloseIVA::setDetalleIVA()
     * @param \StructType\DetalleIVARecibidaType[] $detalleIVA
     */
    public function __construct(array $detalleIVA = array())
    {
        $this
            ->setDetalleIVA($detalleIVA);
    }
    /**
     * Get DetalleIVA value
     * @return \StructType\DetalleIVARecibidaType[]|null
     */
    public function getDetalleIVA()
    {
        return $this->DetalleIVA;
    }
    /**
     * Set DetalleIVA value
     * @throws \InvalidArgumentException
     * @param \StructType\DetalleIVARecibidaType[] $detalleIVA
     * @return \StructType\DesgloseIVA
     */
    public function setDetalleIVA(array $detalleIVA = array())
    {
        foreach ($detalleIVA as $desgloseIVADetalleIVAItem) {
            // validation for constraint: itemType
            if (!$desgloseIVADetalleIVAItem instanceof \StructType\DetalleIVARecibidaType) {
                throw new \InvalidArgumentException(sprintf('The DetalleIVA property can only contain items of \StructType\DetalleIVARecibidaType, "%s" given', is_object($desgloseIVADetalleIVAItem) ? get_class($desgloseIVADetalleIVAItem) : gettype($desgloseIVADetalleIVAItem)), __LINE__);
            }
        }
        $this->DetalleIVA = $detalleIVA;
        return $this;
    }
    /**
     * Add item to DetalleIVA value
     * @throws \InvalidArgumentException
     * @param \StructType\DetalleIVARecibidaType $item
     * @return \StructType\DesgloseIVA
     */
    public function addToDetalleIVA(\StructType\DetalleIVARecibidaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DetalleIVARecibidaType) {
            throw new \InvalidArgumentException(sprintf('The DetalleIVA property can only contain items of \StructType\DetalleIVARecibidaType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DetalleIVA[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DesgloseIVA
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
