<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatosPresentacionType StructType
 * @subpackage Structs
 */
class DatosPresentacionType extends AbstractStructBase
{
    /**
     * The NIFPresentador
     * Meta informations extracted from the WSDL
     * - documentation: NIF: Secuencia de 9 dígitos o letras mayúsculas
     * - length: 9
     * - pattern: (([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))
     * @var string
     */
    public $NIFPresentador;
    /**
     * The TimestampPresentacion
     * Meta informations extracted from the WSDL
     * - length: 19
     * - pattern: \d{2,2}-\d{2,2}-\d{4,4} \d{2,2}:\d{2,2}:\d{2,2}
     * @var string
     */
    public $TimestampPresentacion;
    /**
     * Constructor method for DatosPresentacionType
     * @uses DatosPresentacionType::setNIFPresentador()
     * @uses DatosPresentacionType::setTimestampPresentacion()
     * @param string $nIFPresentador
     * @param string $timestampPresentacion
     */
    public function __construct($nIFPresentador = null, $timestampPresentacion = null)
    {
        $this
            ->setNIFPresentador($nIFPresentador)
            ->setTimestampPresentacion($timestampPresentacion);
    }
    /**
     * Get NIFPresentador value
     * @return string|null
     */
    public function getNIFPresentador()
    {
        return $this->NIFPresentador;
    }
    /**
     * Set NIFPresentador value
     * @param string $nIFPresentador
     * @return \StructType\DatosPresentacionType
     */
    public function setNIFPresentador($nIFPresentador = null)
    {
        // validation for constraint: length
        if ((is_scalar($nIFPresentador) && strlen($nIFPresentador) !== 9) || (is_array($nIFPresentador) && count($nIFPresentador) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($nIFPresentador) && !preg_match('/(([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))/', $nIFPresentador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([a-z|A-Z]{1}\d{7}[a-z|A-Z]{1})|(\d{8}[a-z|A-Z]{1})|([a-z|A-Z]{1}\d{8}))", "%s" given', var_export($nIFPresentador, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nIFPresentador) && !is_string($nIFPresentador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nIFPresentador)), __LINE__);
        }
        $this->NIFPresentador = $nIFPresentador;
        return $this;
    }
    /**
     * Get TimestampPresentacion value
     * @return string|null
     */
    public function getTimestampPresentacion()
    {
        return $this->TimestampPresentacion;
    }
    /**
     * Set TimestampPresentacion value
     * @param string $timestampPresentacion
     * @return \StructType\DatosPresentacionType
     */
    public function setTimestampPresentacion($timestampPresentacion = null)
    {
        // validation for constraint: length
        if ((is_scalar($timestampPresentacion) && strlen($timestampPresentacion) !== 19) || (is_array($timestampPresentacion) && count($timestampPresentacion) !== 19)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 19 element(s) or a scalar of 19 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($timestampPresentacion) && !preg_match('/\d{2,2}-\d{2,2}-\d{4,4} \d{2,2}:\d{2,2}:\d{2,2}/', $timestampPresentacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d{2,2}-\d{2,2}-\d{4,4} \d{2,2}:\d{2,2}:\d{2,2}", "%s" given', var_export($timestampPresentacion, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($timestampPresentacion) && !is_string($timestampPresentacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestampPresentacion)), __LINE__);
        }
        $this->TimestampPresentacion = $timestampPresentacion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatosPresentacionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
