<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatosInmuebleType StructType
 * @subpackage Structs
 */
class DatosInmuebleType extends AbstractStructBase
{
    /**
     * The SituacionInmueble
     * @var string
     */
    public $SituacionInmueble;
    /**
     * The ReferenciaCatastral
     * Meta informations extracted from the WSDL
     * - maxLength: 25
     * @var string
     */
    public $ReferenciaCatastral;
    /**
     * Constructor method for DatosInmuebleType
     * @uses DatosInmuebleType::setSituacionInmueble()
     * @uses DatosInmuebleType::setReferenciaCatastral()
     * @param string $situacionInmueble
     * @param string $referenciaCatastral
     */
    public function __construct($situacionInmueble = null, $referenciaCatastral = null)
    {
        $this
            ->setSituacionInmueble($situacionInmueble)
            ->setReferenciaCatastral($referenciaCatastral);
    }
    /**
     * Get SituacionInmueble value
     * @return string|null
     */
    public function getSituacionInmueble()
    {
        return $this->SituacionInmueble;
    }
    /**
     * Set SituacionInmueble value
     * @uses \EnumType\SituacionInmuebleType::valueIsValid()
     * @uses \EnumType\SituacionInmuebleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $situacionInmueble
     * @return \StructType\DatosInmuebleType
     */
    public function setSituacionInmueble($situacionInmueble = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SituacionInmuebleType::valueIsValid($situacionInmueble)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $situacionInmueble, implode(', ', \EnumType\SituacionInmuebleType::getValidValues())), __LINE__);
        }
        $this->SituacionInmueble = $situacionInmueble;
        return $this;
    }
    /**
     * Get ReferenciaCatastral value
     * @return string|null
     */
    public function getReferenciaCatastral()
    {
        return $this->ReferenciaCatastral;
    }
    /**
     * Set ReferenciaCatastral value
     * @param string $referenciaCatastral
     * @return \StructType\DatosInmuebleType
     */
    public function setReferenciaCatastral($referenciaCatastral = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($referenciaCatastral) && strlen($referenciaCatastral) > 25) || (is_array($referenciaCatastral) && count($referenciaCatastral) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($referenciaCatastral) ? strlen($referenciaCatastral) : count($referenciaCatastral)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referenciaCatastral) && !is_string($referenciaCatastral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenciaCatastral)), __LINE__);
        }
        $this->ReferenciaCatastral = $referenciaCatastral;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatosInmuebleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
