<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabeceraSii StructType
 * Meta informations extracted from the WSDL
 * - documentation: Datos de contexto de un suministro
 * @subpackage Structs
 */
class CabeceraSii extends AbstractStructBase
{
    /**
     * The IDVersionSii
     * @var string
     */
    public $IDVersionSii;
    /**
     * The Titular
     * Meta informations extracted from the WSDL
     * - documentation: Titular de los libros de registro que suministra la información
     * @var \StructType\PersonaFisicaJuridicaESType
     */
    public $Titular;
    /**
     * The TipoComunicacion
     * @var string
     */
    public $TipoComunicacion;
    /**
     * Constructor method for CabeceraSii
     * @uses CabeceraSii::setIDVersionSii()
     * @uses CabeceraSii::setTitular()
     * @uses CabeceraSii::setTipoComunicacion()
     * @param string $iDVersionSii
     * @param \StructType\PersonaFisicaJuridicaESType $titular
     * @param string $tipoComunicacion
     */
    public function __construct($iDVersionSii = null, \StructType\PersonaFisicaJuridicaESType $titular = null, $tipoComunicacion = null)
    {
        $this
            ->setIDVersionSii($iDVersionSii)
            ->setTitular($titular)
            ->setTipoComunicacion($tipoComunicacion);
    }
    /**
     * Get IDVersionSii value
     * @return string|null
     */
    public function getIDVersionSii()
    {
        return $this->IDVersionSii;
    }
    /**
     * Set IDVersionSii value
     * @uses \EnumType\VersionSiiType::valueIsValid()
     * @uses \EnumType\VersionSiiType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDVersionSii
     * @return \StructType\CabeceraSii
     */
    public function setIDVersionSii($iDVersionSii = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VersionSiiType::valueIsValid($iDVersionSii)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iDVersionSii, implode(', ', \EnumType\VersionSiiType::getValidValues())), __LINE__);
        }
        $this->IDVersionSii = $iDVersionSii;
        return $this;
    }
    /**
     * Get Titular value
     * @return \StructType\PersonaFisicaJuridicaESType|null
     */
    public function getTitular()
    {
        return $this->Titular;
    }
    /**
     * Set Titular value
     * @param \StructType\PersonaFisicaJuridicaESType $titular
     * @return \StructType\CabeceraSii
     */
    public function setTitular(\StructType\PersonaFisicaJuridicaESType $titular = null)
    {
        $this->Titular = $titular;
        return $this;
    }
    /**
     * Get TipoComunicacion value
     * @return string|null
     */
    public function getTipoComunicacion()
    {
        return $this->TipoComunicacion;
    }
    /**
     * Set TipoComunicacion value
     * @uses \EnumType\ClaveTipoComunicacionType::valueIsValid()
     * @uses \EnumType\ClaveTipoComunicacionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoComunicacion
     * @return \StructType\CabeceraSii
     */
    public function setTipoComunicacion($tipoComunicacion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClaveTipoComunicacionType::valueIsValid($tipoComunicacion)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoComunicacion, implode(', ', \EnumType\ClaveTipoComunicacionType::getValidValues())), __LINE__);
        }
        $this->TipoComunicacion = $tipoComunicacion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabeceraSii
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
