<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Suministro ServiceType
 * @subpackage Services
 */
class Suministro extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SuministroLRFacturasEmitidas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SuministroLRFacturasEmitidas $suministroLRFacturasEmitidas
     * @return \StructType\RespuestaLRFEmitidasType|bool
     */
    public function SuministroLRFacturasEmitidas(\StructType\SuministroLRFacturasEmitidas $suministroLRFacturasEmitidas)
    {
        try {
            $this->setResult(self::getSoapClient()->SuministroLRFacturasEmitidas($suministroLRFacturasEmitidas));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RespuestaLRFEmitidasType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
