<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultaLRFacturasEmitidas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LRConsultaEmitidasType $consultaLRFacturasEmitidas
     * @return \StructType\RespuestaConsultaLRFacturasEmitidasType|bool
     */
    public function ConsultaLRFacturasEmitidas(\StructType\LRConsultaEmitidasType $consultaLRFacturasEmitidas)
    {
        try {
            $this->setResult(self::getSoapClient()->ConsultaLRFacturasEmitidas($consultaLRFacturasEmitidas));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RespuestaConsultaLRFacturasEmitidasType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
